package yangtz.cs.liu.wechat.controller.interest;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.framework.util.UserInfoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClasses;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesChild;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesChildService;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesService;
import yangtz.cs.liu.campus.vo.interest.ChildVO;
import yangtz.cs.liu.wechat.vo.interest.ClassVO;
import java.util.List;

@RestController
@RequestMapping("/wx/interestClass")
public class WxSchoolInterestClassesController extends BaseController {
    @Autowired
    private ISchoolInterestClassesService schoolInterestClassesService;
    @Autowired
    private ISchoolInterestClassesChildService schoolInterestClassesChildService;
    @Autowired
    UserInfoUtil userInfoUtil;

    /**
     * 查询家长端兴趣班列表(全部兴趣班)
     */
    @GetMapping("/stuAllClassesList")
    public TableDataInfo stuAllClassesList(SchoolInterestClasses schoolInterestClasses)
    {
        startPage();
        List<ClassVO> list = schoolInterestClassesService.queryAllClassesList(schoolInterestClasses);
        return getDataTable(list);
    }

    /**
     * 某兴趣班更多信息
     */
    @GetMapping("/stuAllClassesList/{id}")
    public AjaxResult stuClassesInfo(@PathVariable Long id)
    {
        return AjaxResult.success(schoolInterestClassesService.getInfoById(id));
    }

    /**
     * 学生报名
     */
    @PostMapping("/add/{interestClassesId}")
    public AjaxResult addChild(@PathVariable Long interestClassesId)
    {
        return toAjax(schoolInterestClassesChildService.addChild(interestClassesId));
    }

    /**
     * 家长端学生所参加的兴趣班列表
     */
    @GetMapping("/stuClassesList")
    public TableDataInfo stuClassesList(SchoolInterestClasses schoolInterestClasses)
    {
        startPage();
        List<ClassVO> list = schoolInterestClassesService.queryStuClassesList(schoolInterestClasses);
        return getDataTable(list);
    }

    /**
     * 查询教师端兴趣班列表(全部兴趣班)
     */
    @GetMapping("/teaAllClassesList")
    public TableDataInfo teaAllClassesList(SchoolInterestClasses schoolInterestClasses)
    {
        startPage();
        List<ClassVO> list = schoolInterestClassesService.queryAllClassesList(schoolInterestClasses);
        return getDataTable(list);
    }

    /**
     * 查询教师端教师所开设的兴趣班列表
     */
    @GetMapping("/teacherClassesList")
    public TableDataInfo teacherClassesList(ClassVO classVO)
    {
        startPage();
        List<ClassVO> list = schoolInterestClassesService.queryTeacherClassesList(classVO);
        return getDataTable(list);
    }

    /**
     * 获取教师端兴趣班详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolInterestClassesService.getById(id));
    }

    /**
     * 获取兴趣班下学生列表
     */
    @GetMapping(value = "/getChildList/{interestClassesId}")
    public TableDataInfo getChildList(@PathVariable Long interestClassesId, SchoolInterestClassesChild child)
    {
        startPage();
        List<ChildVO> list = schoolInterestClassesChildService.queryList(child,interestClassesId);
        return getDataTable(list);
    }
}
