package yangtz.cs.liu.wechat.controller.experiment;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.MpLoginUser;
import com.ruoyi.framework.util.UserInfoUtil;
import com.ruoyi.system.service.ISysDictDataService;
import com.ruoyi.system.service.ISysRoleService;
import com.ruoyi.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYear;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApply;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherLabApply;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabClassYearService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherExperimentApplyService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherLabApplyService;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherExperimentApplyVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherLabApplyVo;

import java.util.List;

/**
 * 实验室 老师申请
 */
@RestController
@RequestMapping("/wx/teacher/expriment")
public class TeacherExperimentController extends BaseController {

  /**
   * 实验室申请
   */
  @Autowired
  private ISchoolTeacherLabApplyService schoolTeacherLabApplyService;
  /**
   * 级部申请
   */
  @Autowired
  ISchoolLabClassYearService schoolLabClassYearService;

  //学校班级
  @Autowired
  ISchoolClassService iSchoolClassService;

  /**
   * 个人申请记录
   */
  @Autowired
  ISchoolTeacherExperimentApplyService schoolTeacherExperimentApplyService;
  /**
   * 年级计划申请列表
   */

  @GetMapping(value = "/classYear/list")
  public AjaxResult classYearlist(SchoolLabClassYearVo schoolLabClassYearVo)
  {
    List<SchoolLabClassYearVo> schoolLabClassYears = schoolLabClassYearService.selectSchoolLabClassYearList(
            schoolLabClassYearVo);
    return AjaxResult.success(schoolLabClassYears);
  }

  /**
   * 老师申请实验室
   */
  @PostMapping("/add")
  public AjaxResult add(@RequestBody SchoolTeacherLabApplyVo schoolTeacherLabApply)
  {
    schoolTeacherLabApply.setState("0");
    schoolTeacherLabApply.setApplyState("0");
    return toAjax(schoolTeacherLabApplyService.insertSchoolTeacherLabApplyVo(schoolTeacherLabApply));
  }
  /**
   * 获取实验计划详细信息
   */
  @GetMapping(value = "/classYear/{id}")
  public AjaxResult getclassYearInfo(@PathVariable("id") Long id)
  {
    return AjaxResult.success(schoolLabClassYearService.selectSchoolLabClassYearById(id));
  }

  /**
   * 获取实验室状态
   */

  @GetMapping(value = "/getTeacherLab")
  public AjaxResult getclassYearInfo(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
  {
    return AjaxResult.success(schoolTeacherLabApplyService.getTeacherLab(schoolTeacherLabApplyVo));
  }

  @Autowired
  UserInfoUtil userInfoUtil;
  @Autowired
  ISysUserService userService;

  @Autowired
  ISysRoleService roleService;

  @Autowired
  ISysDictDataService dictDataService;
  /**
   * 获取班级
   */

  @GetMapping(value = "/getTeacherClass")
  public AjaxResult getTeacherClass(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
  {
    Long userId = userInfoUtil.getMpLoginUser().getUserId();
    SysUser sysUser = userService.selectUserById(userId);
    return AjaxResult.success(schoolTeacherLabApplyService.getTeacherClass(schoolTeacherLabApplyVo,sysUser));
  }


  /**
   * 实验室申请记录
   */
  @GetMapping(value = "/list")
  public AjaxResult list(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
  {
    return AjaxResult.success(schoolTeacherLabApplyService.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo));
  }
  /**
   * 实验室申请详情
   */
  @GetMapping(value = "/{id}")
  public AjaxResult getrecordInfo(@PathVariable("id") Long id)
  {
    return AjaxResult.success(schoolTeacherLabApplyService.selectSchoolTeacherLabApplyById(id));
  }

/**
 * 个人实验室申请列表
 */

  @GetMapping(value = "/apply/list")
  public AjaxResult applyList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo)
  {
  return AjaxResult.success(schoolTeacherExperimentApplyService.selectSchoolTeacherExperimentApplyList(schoolTeacherExperimentApplyVo));
  }

  /**
  * 个人实验室申请详情
  */
  @GetMapping(value = "/apply/{id}")
  public AjaxResult applyGetInfo(@PathVariable("id") Long id)
  {
   return AjaxResult.success(schoolTeacherExperimentApplyService.selectSchoolTeacherExperimentApplyById(id));
  }

  /**
   * 获取当前登录角色学科
   */

  @GetMapping("/getSubject")
  public AjaxResult getSubject(){
    Long userId = userInfoUtil.getMpLoginUser().getUserId();
    List<SysRole> sysRoles = roleService.selectRolesByUserIdDdApp(userId);
    for (SysRole role : sysRoles) {
       if (role.getRoleKey().equals("phy_lab_admin")){
          return AjaxResult.success(dictDataService.selectDictLabel("lab_sub","1"));
      }else if (role.getRoleKey().equals("che_lab_admin")){
         return AjaxResult.success(dictDataService.selectDictLabel("lab_sub","2"));
      }else if (role.getRoleKey().equals("bio_lab_admin")){
         return AjaxResult.success(dictDataService.selectDictLabel("lab_sub","3"));
      }
    }
    return AjaxResult.success("当前用户未分配学科角色");

  }


  /**
   *新增申请
   */
  @PostMapping("/apply/add")
  public AjaxResult applyAdd(@RequestBody SchoolTeacherExperimentApply schoolTeacherExperimentApply)
  {
    return toAjax(schoolTeacherExperimentApplyService.save(schoolTeacherExperimentApply));
  }


  /**
   * 申报
   */
  @PutMapping("/apply/report")
  public AjaxResult applyReport(@RequestBody SchoolTeacherExperimentApply schoolTeacherExperimentApply)
  {
    schoolTeacherExperimentApply.setDeclareState("1");
    return toAjax(schoolTeacherExperimentApplyService.updateById(schoolTeacherExperimentApply));
  }

  /**
   * 修改申请
   */
  @PutMapping("/apply/update")
  public AjaxResult applyUpdate(@RequestBody SchoolTeacherExperimentApply schoolTeacherExperimentApply)
  {
    return toAjax(schoolTeacherExperimentApplyService.updateById(schoolTeacherExperimentApply));
  }

  /**
   * 删除教师个人实验申请
   */
  @DeleteMapping("/apply/{ids}")
  public AjaxResult remove(@PathVariable Long[] ids)
  {
    return toAjax(schoolTeacherExperimentApplyService.deleteSchoolTeacherExperimentApplyByIds(ids));
  }

}
