package yangtz.cs.liu.wechat.controller.experiment;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import java.util.Calendar;
import java.util.List;

import com.ruoyi.system.service.ISysDeptService;
import com.ruoyi.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYear;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherExperimentApply;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherLabApply;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.mapper.schoolLab.SchoolTeacherLabApplyMapper;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolExperimentPlanService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabClassYearService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherLabApplyService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.vo.schoolLab.ClassSituationVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolExperimentPlanVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherLabApplyVo;

import java.util.List;

/**
 * 实验室 级部申请
 */
@RestController
@RequestMapping("/wx/level/expriment")
public class ExperimentLevelController extends BaseController {

  @Autowired
  ISchoolLabClassYearService schoolLabClassYearService;

  @Autowired
  private ISchoolExperimentPlanService schoolExperimentPlanService;

  @Autowired
  private ISchoolTeacherLabApplyService schoolTeacherLabApplyService;


  @Autowired
  private ISchoolGradeService schoolGradeService;


  @Autowired
  private ISysUserService userService;

  @Autowired
  private  ISysDeptService deptService;
  /**
   * 获取当前学年+学期
   */
  @GetMapping("/getSemester")
  public AjaxResult getSemester(){
    AjaxResult ajaxResult = AjaxResult.success();
    Calendar cal = Calendar.getInstance();
    //获取当前年月
    int month = cal.get(Calendar.MONTH) + 1;
    //设置当前学期
    String term = "1";
    //2-7为第二学期，8-1为第一学期
    //如果当前月份小于8月，则该学年应为当前年-1 到 当前年,例如当前年月为2023年7月，则该学年为2022-2023年的第二学期
    if (month >= 2 && month < 8) {
      term = "2";
    }
    int schoolYear = schoolGradeService.isNewSchoolYear();
    ajaxResult.put("semester",term);
    ajaxResult.put("schoolYear",schoolYear);
    return ajaxResult;
  }



  @Log(title = "年级实验室预约", businessType = BusinessType.INSERT)
  @PostMapping("/add")
  public AjaxResult add(@RequestBody SchoolLabClassYear schoolLabClassYear)
  {
    return toAjax(schoolLabClassYearService.insertSchoolLabClassYear(schoolLabClassYear));

  }

  /**
   * 获取实验计划
   * 传入 级部
   */
  @GetMapping("/pxperimentPlanList")
  public AjaxResult pxperimentPlanList(SchoolExperimentPlanVo schoolExperimentPlanVo)
  {
    schoolExperimentPlanVo.setSub(schoolLabClassYearService.getSub());
    return AjaxResult.success(schoolExperimentPlanService.selectNameByVo(schoolExperimentPlanVo));
  }
  /**
   * 获取实验计划详细信息
   */
  @GetMapping(value = "/{id}")
  public AjaxResult getInfo(@PathVariable("id") Long id)
  {
    return AjaxResult.success(schoolExperimentPlanService.selectSchoolExperimentPlanById(id));
  }


    @Log(title = "年级预约详情", businessType = BusinessType.INSERT)
  @GetMapping("getInfo/{id}")
  public AjaxResult getClassInfo(@PathVariable("id") Long id)
  {
    return AjaxResult.success(schoolLabClassYearService.selectSchoolLabClassYearById(id));
  }

  /**
   * 获取人员级部
   */
  @GetMapping("/getGrades")
  public AjaxResult getGrade(SchoolLabClassYearVo schoolLabClassYearVo)
  {   //获取最新学年
    int schoolYear = schoolGradeService.isNewSchoolYear();
    //获取学年分组信息
    List<String> strings = schoolGradeService.selectSchoolYearGruoUp();
    return AjaxResult.success(strings);
  }

  /**
   * 获取学年下拉表
   */
  @GetMapping("/gradeYear")
  public AjaxResult gradeYear()
  {
    return AjaxResult.success(schoolLabClassYearService.getYearList());
  }

  /**
   * 申报
   */
  @PutMapping("/report")
  public AjaxResult applyReport( @RequestBody SchoolLabClassYear schoolLabClassYear)
  {
    schoolLabClassYear.setDeclareState("1");
    return toAjax(schoolLabClassYearService.updateById(schoolLabClassYear));
  }

  /**
   *获取级部预约列表
   */
  @GetMapping("/list")
  public AjaxResult list(SchoolLabClassYearVo schoolLabClassYear)
  {
    return AjaxResult.success(schoolLabClassYearService.getLabClassYear(schoolLabClassYear));
  }

  /**
   * 修改
   */
  @PutMapping("/update")
  public AjaxResult update(@RequestBody SchoolLabClassYear schoolLabClassYear)
  {

    return toAjax(schoolLabClassYearService.updateSchoolLabClassYear(schoolLabClassYear));
  }

  /**
   * 删除年级实验室预约
   */
  @DeleteMapping("/{ids}")
  public AjaxResult remove(@PathVariable Long[] ids)
  {
    return toAjax(schoolLabClassYearService.deleteSchoolLabClassYearByIds(ids));
  }


  /**
   * 查看班级完成情况
   */
  @GetMapping("/getClassExperimentList")
  public AjaxResult classSituation(ClassSituationVo classSituationVo){
    List<ClassSituationVo> classSituationVos = schoolLabClassYearService.classSituation(
        classSituationVo);
    return AjaxResult.success(classSituationVos);
  }

  /**
   * 班级完成详情
   */
  @GetMapping("/getClassExperimentalDetails")
  public AjaxResult getClassExperimentalDetails(SchoolTeacherLabApplyVo schoolTeacherLabApply){
    List<SchoolTeacherLabApplyVo> list = schoolTeacherLabApplyService.selectSchoolTeacherLabApplyList(schoolTeacherLabApply);
    return AjaxResult.success(list);
  }




  /**
   * 实验室完成情况
   */
  @GetMapping("/getexperimentList")
  public AjaxResult getexperimentList(ClassSituationVo classSituationVo){
    List<ClassSituationVo> classSituationVos = schoolLabClassYearService.getexperimentList(
        classSituationVo);
    return AjaxResult.success(classSituationVos);
  }

  /**
   *实验室完成详情
   */
  @GetMapping("/teacherExperimentList")
  public AjaxResult teacherExperimentList(ClassSituationVo classSituationVo){
    SchoolLabClassYearVo schoolLabClassYear = new SchoolLabClassYearVo();
    schoolLabClassYear.setExperimentPlanId(classSituationVo.getId());
    List<SchoolLabClassYearVo> schoolLabClassYears = schoolLabClassYearService.selectSchoolLabClassYearList(
        schoolLabClassYear);
    if (!schoolLabClassYears.isEmpty()){
      classSituationVo.setLabClassYearId(schoolLabClassYears.get(0).getId());
    }
    List<SchoolTeacherLabApplyVo> teacherExperimentList = schoolTeacherLabApplyService.getTeacherExperimentList(
        classSituationVo);
    return AjaxResult.success(teacherExperimentList);
  }

  /**
   * 获取教师所在级部id
   */
  @GetMapping("/getGrade/{userId}")
  public AjaxResult getGrade(@PathVariable("userId") Long userId) {
    Long gradeId =null;
    SysUser sysUser = userService.selectUserById(userId);
    String ancestors = sysUser.getDept().getAncestors();

    if (ancestors.length()!=2){
      String[] split = ancestors.split(",");
      SysDept sysDept = deptService.selectDeptById(Long.valueOf(split[2]));
      //根据级部名称去查询id
      SchoolGrade schoolGrade = schoolGradeService.selectGradeByName(sysDept.getDeptName());
      gradeId = schoolGrade.getId();
    }else {
      return AjaxResult.success("当前老师不在级部内");
    }
    return AjaxResult.success(gradeId);
  }
}
