package yangtz.cs.liu.wechat.controller.experiment;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYear;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherLabApply;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolLabClassYearService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherExperimentApplyService;
import yangtz.cs.liu.campus.service.schoolLab.ISchoolTeacherLabApplyService;
import yangtz.cs.liu.campus.vo.schoolLab.ClassSituationVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherExperimentApplyVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherLabApplyVo;

import java.util.List;
import java.util.Map;

/**
 * 实验室管理员
 */
@RestController
@RequestMapping("/wx/administrators")
public class ExperimentAdministratorsControoler extends BaseController {

  /**
   * 年级申请
   */
  @Autowired
  ISchoolLabClassYearService schoolLabClassYearService;
  /**
   * 实验室申请
   */
  @Autowired
  private ISchoolTeacherLabApplyService schoolTeacherLabApplyService;


  /**
   * 个人申请记录
   */
  @Autowired
  ISchoolTeacherExperimentApplyService schoolTeacherExperimentApplyService;



  /**
   * 年级实验室分分配列表
   */
  @GetMapping("/classYear/list")
  public AjaxResult classYearList(SchoolLabClassYearVo schoolLabClassYearVo)
  {

    schoolLabClassYearVo.setSub(schoolLabClassYearService.getSub());
    return AjaxResult.success(schoolLabClassYearService.selectSchoolLabClassYearList(schoolLabClassYearVo));
  }


  /**
   * 年级实验申请详情
   */

  @GetMapping(value = "/classYear/{id}")
  public AjaxResult classYearGetInfo(@PathVariable("id") Long id)
  {
    return AjaxResult.success(schoolLabClassYearService.getLabClassYearById(id));
  }

  /**
   * 年级实验申请分配
   */
  @PutMapping("/classYear/update")
  public AjaxResult classYearUpdate(@RequestBody SchoolLabClassYearVo schoolLabClassYear)
      throws ParseException {
    SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");

    //截取时间
    String[] dateArrays = schoolLabClassYear.getDateArrays();
    String dateArray = dateArrays[0];
    String dateArray1 = dateArrays[1];
    Date stDate = ft.parse(dateArray);
    Date enDate = ft.parse(dateArray1);
    schoolLabClassYear.setPlannedStartTime(stDate);
    schoolLabClassYear.setPlannedEndTime(enDate);
    return toAjax(schoolLabClassYearService.updateLabClassYear(schoolLabClassYear));
  }




  /**
   * 教师实验室预约列表
   */
  @GetMapping(value = "/teacher/list")
  public AjaxResult teacherList(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo)
  {
    schoolTeacherLabApplyVo.setSub(schoolLabClassYearService.getSub());
    return AjaxResult.success(schoolTeacherLabApplyService.selectSchoolTeacherLabApplyList(schoolTeacherLabApplyVo));
  }

  /**
   * 实验室申请详情
   */
  @GetMapping(value = "/teacher/{id}")
  public AjaxResult teacherGetInfo(@PathVariable("id") Long id)
  {
    return AjaxResult.success(schoolTeacherLabApplyService.selectSchoolTeacherLabApplyById(id));
  }
  /**
   * 实验室申请详情审批
   */
  @PutMapping("/teacher/update")
  public AjaxResult teacherUpdate(@RequestBody SchoolTeacherLabApply schoolTeacherLabApply)
  {
    schoolTeacherLabApply.setApplyState("1");
    return toAjax(schoolTeacherLabApplyService.updateById(schoolTeacherLabApply));
  }

  /**
   * 个人实验室申请列表
   */

  @GetMapping(value = "/apply/list")
  public AjaxResult applyList(SchoolTeacherExperimentApplyVo schoolTeacherExperimentApplyVo)
  {
    schoolTeacherExperimentApplyVo.setSub(schoolLabClassYearService.getSub());
    return AjaxResult.success(schoolTeacherExperimentApplyService.selectSchoolTeacherExperimentApplyList(schoolTeacherExperimentApplyVo));
  }

  /**
   * 个人实验室审批
   */
  @PutMapping("/apply/update")
  public AjaxResult applyUpdate(@RequestBody SchoolTeacherExperimentApplyVo schoolTeacherExperimentApply)
  {
    return toAjax(schoolTeacherExperimentApplyService.teacherExperimentLabs(schoolTeacherExperimentApply));
  }

  /**
   * 个人实验室申请详情
   */
  @GetMapping(value = "/apply/{id}")
  public AjaxResult applyGetInfo(@PathVariable("id") Long id)
  {
    return AjaxResult.success(schoolTeacherExperimentApplyService.selectSchoolTeacherExperimentApplyById(id));
  }

  /**
   * 实验室完成情况
   */
  @GetMapping("/getexperimentList")
  public AjaxResult getexperimentList(ClassSituationVo classSituationVo){
    List<ClassSituationVo> classSituationVos = schoolLabClassYearService.getexperimentList(
        classSituationVo);
    return AjaxResult.success(classSituationVos);
  }





  /**
   * 实验室完成详情
   */
  @GetMapping("/teacherExperimentList")
  public AjaxResult teacherExperimentList(ClassSituationVo classSituationVo){
    LambdaQueryWrapper<SchoolLabClassYear> lw = new LambdaQueryWrapper();
    lw.eq(SchoolLabClassYear::getExperimentPlanId,classSituationVo.getId());
    SchoolLabClassYear one = schoolLabClassYearService.getOne(lw);
    classSituationVo.setLabClassYearId(one.getId());

    List<SchoolTeacherLabApplyVo> teacherExperimentList = schoolTeacherLabApplyService.getTeacherExperimentList(
        classSituationVo);
    return AjaxResult.success(teacherExperimentList);
  }

  /**
   * 教师实验统计
   */
  @GetMapping("/teachaer/List")
  public AjaxResult teachaerList(SchoolTeacherLabApply schoolTeacherLabApply){
    List<Map<String, String>> maps = schoolTeacherLabApplyService.selectTeacherList(
        schoolTeacherLabApply);
    return AjaxResult.success(maps);
  }

}
