package yangtz.cs.liu.wechat.controller.equipment;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.system.service.ISysRoleService;
import com.ruoyi.system.service.ISysUserService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolCirculation;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentLedger;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentRepair;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolReceive;
import yangtz.cs.liu.campus.service.equipment.SchoolReceiveService;
import yangtz.cs.liu.campus.service.schoolEquipment.ICirculationService;
import yangtz.cs.liu.campus.service.schoolEquipment.IEquipmentLedgerService;
import yangtz.cs.liu.campus.service.schoolEquipment.IEquipmentRepairService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolCirculationVo;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentRepairVo;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveQuery;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveVo;

/**
 * 移动端，设备租借、领用
 */
@RestController
@RequestMapping("/wx/equipment")
public class EquipmentLeaseController {

  @Autowired
  IEquipmentLedgerService iEquipmentService;


  @Autowired
  IEquipmentRepairService iEquipmentRepairService;

  @Autowired
  ICirculationService iCirculationService;

  @Autowired
  SchoolReceiveService schoolReceiveService;

  @Autowired
  ISysUserService iSysUserService;

  @Autowired
  ISysRoleService iSysRoleService;
  /**
   * 扫码借用获取设备基本信息
   */
  @GetMapping("/getEquipment/{encode}")
  private AjaxResult getEquipment(@PathVariable("encode") String encode){
    LambdaQueryWrapper<SchoolEquipmentLedger> wrapper =  new LambdaQueryWrapper<>();
    wrapper.eq(SchoolEquipmentLedger::getEncode,encode);
    SchoolEquipmentLedger one = iEquipmentService.getOne(wrapper);
    if (one==null){
      return new AjaxResult(3000,"设备信息未找到");
    }else {
      return AjaxResult.success(one);
    }
  }

  /**
   * 我的借用记录
   */
  @GetMapping("/getMyBorrowList")
  private AjaxResult getMyBorrowList(SchoolReceiveQuery  schoolReceiveQuery){
    List<SchoolCirculationVo> schoolCirculationVos = iCirculationService
        .selectVxSchoolCirculationVoList(schoolReceiveQuery);
    return AjaxResult.success(schoolCirculationVos);
  }

  /**
   * 扫码借用
   */
  @PostMapping("/addRecord")
  private AjaxResult addRecord(@RequestBody SchoolCirculation schoolCirculation){
    Date borrowTime = schoolCirculation.getBorrowTime();
    Long deadline = schoolCirculation.getDeadline();
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(borrowTime);
    calendar.add(Calendar.DATE,Integer.valueOf(deadline.toString()));
    Date targetDate = calendar.getTime();
    schoolCirculation.setReturnState("0");
    schoolCirculation.setReturnTime(targetDate);
    boolean save = iCirculationService.save(schoolCirculation);
   //修改设备表借出状态
    SchoolEquipmentLedger byId = iEquipmentService.getById(schoolCirculation.getEquipmentId());
    byId.setIsLend("1");
    iEquipmentService.updateById(byId);
    return AjaxResult.success(save);
  }

  /**
   * 扫码借用查看
   */
  @GetMapping("/byCirculation/{id}")
  private AjaxResult byCirculation(@PathVariable("id") Long id){
    SchoolCirculationVo byId = iCirculationService.getSchoolCirculationVoById(id);
    return AjaxResult.success(byId);
  }

  /**
   * 领用台账list
   */
  @GetMapping("/getUseList")
  private AjaxResult getUseList(SchoolReceiveQuery schoolReceiveQuery){
    List<SchoolReceiveVo> recipientByIdlist = schoolReceiveService
        .getRecipientByIdlist(schoolReceiveQuery);
    return AjaxResult.success(recipientByIdlist);
  }

  /**
   * 领用台账查询
   */
  @GetMapping("/getUseById/{Id}")
  private AjaxResult getUseById(@PathVariable("Id") Long Id){
    SchoolReceiveVo byId = schoolReceiveService.getRecipientById(Id);
    return AjaxResult.success(byId);
  }

  /**
   * 新增领用
   */
  @PostMapping("/addUsedevice")
  private AjaxResult addUsedevice(@RequestBody SchoolReceive schoolReceive){
    //领取修改设备信息
    SchoolEquipmentLedger one = iEquipmentService.getById(schoolReceive.getEquipmentId());
    one.setUseId(Long.valueOf(schoolReceive.getRecipientById()));
    one.setUseName(schoolReceive.getRecipientBy());
    one.setAffiliationType("3");
    iEquipmentService.updateById(one);
    boolean save = schoolReceiveService.save(schoolReceive);
    return AjaxResult.success(save);
  }



  /**
   * 设备维修-列表
   */
  @GetMapping("/getMaintenanceList")
  private AjaxResult getMaintenanceList(SchoolReceiveQuery schoolReceiveQuery){
    Boolean flag= false;
    //1.管理员可以查看所有维修列表
    SysUser sysUser = iSysUserService.selectUserById(schoolReceiveQuery.getReportRepairid());
    List<SysRole> roles = sysUser.getRoles();
    for(SysRole data :roles){
      if (data.getRoleKey().contains("productCategoryAdmin")){
          flag=true;
         break;
      }
    };
    if (false){
      List<SchoolEquipmentRepairVo> getlist = iEquipmentRepairService.getAdminList(schoolReceiveQuery);
      return AjaxResult.success(getlist);
    }else {
      List<SchoolEquipmentRepairVo> maintenanceList = iEquipmentRepairService
          .getMaintenanceList(schoolReceiveQuery);
      return AjaxResult.success(maintenanceList);
    }
  }

  /**
   * 设备维修-新增
   */
  @PostMapping("/addMaintenance")
  private AjaxResult addMaintenance(@RequestBody SchoolEquipmentRepair schoolEquipmentRepair){
    boolean save = iEquipmentRepairService.save(schoolEquipmentRepair);
    return AjaxResult.success(save);
  }

  /**
   * 设备报修台账查看
   */
  @GetMapping("/getMaintenance/{id}")
  private AjaxResult getMaintenance(@PathVariable("id") Long id){
    SchoolEquipmentRepairVo equipmentById = iEquipmentRepairService.getEquipmentById(id);
    return AjaxResult.success(equipmentById);
  }
  /**
   * 设备报修修改
   */
  @PutMapping("/pudateMaintenance")
  private AjaxResult pudateMaintenance(@RequestBody SchoolEquipmentRepair schoolEquipmentRepair){
    boolean save = iEquipmentRepairService.updateById(schoolEquipmentRepair);
    return AjaxResult.success(save);
  }

  /**
   * 设备报修删除
   */
  @DeleteMapping("/deletEuipemnt/{id}")
  private AjaxResult deletEuipemnt(@PathVariable("id") Long id){
    boolean b = iEquipmentRepairService.removeById(id);
    return AjaxResult.success(b);
  }
  /**
   * 报修台账反馈列表 设备维修记录id
   */
  @GetMapping("/getfeedback/{id}")
  private AjaxResult getfeedback(@PathVariable("id") Long id){
    SchoolEquipmentRepairVo equipmentById = iEquipmentRepairService.getEquipmentById(id);
    return AjaxResult.success(equipmentById);
  }

  /**
   * 报修反馈提交
   */
  @PutMapping("/pudateFeedback")
  private AjaxResult pudateFeedback(@RequestBody SchoolEquipmentRepair schoolEquipmentRepair){
    boolean b = iEquipmentRepairService.updateById(schoolEquipmentRepair);
    return AjaxResult.success(b);
  }

  /**
   * 维修人员更改维修状态
   */
  @PutMapping("/confirmRepair")
  private AjaxResult confirmRepair(@RequestBody SchoolEquipmentRepair schoolEquipmentRepair){
    boolean b = iEquipmentRepairService.updateById(schoolEquipmentRepair);
    return AjaxResult.success(b);
  }

  /**
   * 维修人员报修列表
   */
  @GetMapping("getMaintenanceUserList")
  private AjaxResult getMaintenanceUserList(SchoolReceiveQuery schoolReceiveQuery){
    List<SchoolEquipmentRepairVo> maintenanceUserList = iEquipmentRepairService
        .getMaintenanceUserList(schoolReceiveQuery);
    return AjaxResult.success(maintenanceUserList);
  }

  /**
   * 管理员列表查询
   */
  @GetMapping("/getReturningEquipmentList")
  private AjaxResult getReturningEquipmentList(SchoolReceiveQuery schoolReceiveQuery){
    //根据管理员信息查看所有已借出设备信息
    List<SchoolCirculationVo> returningEquipmentByadminId = iCirculationService
        .getReturningEquipmentByadminId(schoolReceiveQuery);
    return AjaxResult.success(returningEquipmentByadminId);
  }

  /**
   * 管理员查看详情
   */
  @GetMapping("/getReturningEquipmentByList/{encode}")
  private AjaxResult getReturningEquipmentByList(@PathVariable("encode") String encode){
    SchoolCirculationVo schoolCirculationVo = new SchoolCirculationVo();
    //先查询物品表有没有借出去
    LambdaQueryWrapper<SchoolEquipmentLedger> wrapper =  new LambdaQueryWrapper<>();
    wrapper.eq(SchoolEquipmentLedger::getEncode,encode);
    SchoolEquipmentLedger one = iEquipmentService.getOne(wrapper);
    if (one.getIsLend().equals("0")){
      //未借出
      schoolCirculationVo.setEquipmentId(one.getId());
      schoolCirculationVo.setEquipmentName(one.getEquipmentName());
      schoolCirculationVo.setModel(one.getModel());
      schoolCirculationVo.setIsLend(one.getIsLend());
      return   AjaxResult.success(schoolCirculationVo);
    }else {
      //已借出
      SchoolCirculationVo schoolCirculationVoByenCode = iCirculationService
          .getSchoolCirculationVoByenCode(encode);
      //根据管理员信息查看信息详情
      return AjaxResult.success(schoolCirculationVoByenCode);
    }

  }

  /**
   * 管理员归还操作
   */
  @PutMapping("returnDevice")
  private AjaxResult returnDevice(@RequestBody SchoolCirculation schoolCirculation){
    schoolCirculation.setReturnState("1");
    boolean b = iCirculationService.updateById(schoolCirculation);
    //修改设备表借出状态
    SchoolEquipmentLedger byId = iEquipmentService.getById(schoolCirculation.getEquipmentId());
    byId.setIsLend("0");
    iEquipmentService.updateById(byId);
    return AjaxResult.success(b);
  }




  /**
   * 获取修理人下拉框
   * @return
   */
  @GetMapping("/getRepair")
  public AjaxResult getRepair(){
    return AjaxResult.success(iEquipmentRepairService.getRepair());
  }

}
