package yangtz.cs.liu.dingding.vo;

import lombok.Data;

/**
 * 用户管理
 */
@Data
public class DingSchoolUserVo {

    /** 员工唯一标识ID（不可修改），企业内必须唯一 */
    private String userid;

    /** 员工在当前开发者企业账号范围内的唯一标识 */
    private String unionid;

    /** 头像 */
    private String avatar;

    /** 员工名称，长度最大80个字符 */
    private String name;

    /** 手机号码，企业内必须唯一，不可重复 */
    private String mobile;

    /** 是否号码隐藏 */
    private Boolean hideMobile;

    /** 分机号，长度最大50个字符 */
    private String telephone;

    /** 员工工号，长度最大为50个字符 */
    private String jobNumber;

    /** 职位，长度最大为200个字符 */
    private String title;

    /** 员工个人邮箱，长度最大50个字符 */
    private String email;

    /** 员工的企业邮箱，长度最大100个字符 */
    private String orgEmail;

    /** 员工的企业邮箱类型  profession: 标准版  base：基础版 */
    private String orgEmailType;

    /** 办公地点，长度最大100个字符 */
    private String workPlace;

    /** 备注，长度最大2000个字符 */
    private String remark;

    /** 所属部门id列表，每次调用最多传100个部门ID */
    private String deptIdList;

    /** 员工在对应的部门中的排序 */
    private String deptOrderList;

    /** 员工在对应的部门中的职位 */
    private String deptTitleList;

    /** 扩展属性，可以设置多种属性，最大长度2000个字符 */
    private String extension;

    /** 是否开启高管模式，默认值false */
    private Boolean seniorMode;

    /** 入职时间，Unix时间戳，单位毫秒 */
    private Long hiredDate;

    /** 直属主管的userId */
    private String managerUserid;

    /** 登录邮箱 */
    private String loginEmail;

    /** 是否为企业账号 */
    private Boolean exclusiveAccount;

    /** 是否激活了钉钉 */
    private Boolean active;

    /** 部门内任职 */
    private String deptPositionList;

    /** 专属账号类型 sso：企业自建专属账号  dingtalk：钉钉自建专属账号 */
    private String exclusiveAccountType;

    /** 专属账号手机号 */
    private String exclusiveMobile;

    /** 手机号验证状态 */
    private String exclusiveMobileVerifyStatus;

    /** 强制更新的字段，支持清空指定的字段，多个字段之间使用逗号分隔。目前支持字段: manager_userid */
    private String forceUpdateFields;

    /** 重置专属账号密码 */
    private String initPassword;

    /** 语言 */
    private String language;

    /** 修改专属账号登录名 */
    private String loginId;

    /** 需要添加的专属账号所属corpid */
    private String outerExclusiveCorpid;

    /** 需要添加的专属账号所属userid */
    private String outerExclusiveUserid;

}
