package yangtz.cs.liu.dingding.vo;

import com.aliyun.dingtalkworkflow_1_0.models.ProcessForecastRequest;
import com.aliyun.dingtalkworkflow_1_0.models.StartProcessInstanceRequest;
import com.aliyun.tea.NameInMap;
import lombok.Data;

import java.util.List;

/**
 * 审批实例
 */
@Data
public class DingProcessInstanceVo {

    /** 不使用审批流模板时，直接指定的审批人列表，最大列表长度：20 */
    @NameInMap("approvers")
    public List<StartProcessInstanceRequest.StartProcessInstanceRequestApprovers> approvers;

    /** 抄送人 userId */
    @NameInMap("ccList")
    public List<String> ccList;

    /** 抄送时间点，取值   START：开始时抄送   FINISH：结束时抄送   START_FINISH：开始和结束时都抄送 */
    @NameInMap("ccPosition")
    public String ccPosition;

    /** 审批发起人所在的部门ID */
    @NameInMap("deptId")
    public Long deptId;

    /** 创建审批实例 : 表单数据内容，控件列表，最大列表长度：150 */
    @NameInMap("formComponentValues")
    public List<StartProcessInstanceRequest.StartProcessInstanceRequestFormComponentValues> formComponentValues;

    /** 获取审批单流程中的节点信息 : 表单数据内容，控件列表，最大列表长度：150 */
    public List<ProcessForecastRequest.ProcessForecastRequestFormComponentValues> formComponentValues1;

    /** 应用标识AgentId */
    @NameInMap("microappAgentId")
    public Long microappAgentId;

    /** 审批发起人的userId */
    @NameInMap("originatorUserId")
    public String originatorUserId;

    /** 即将发起审批单的员工userId值 */
    public String userId;

    /** 审批流的唯一码 */
    @NameInMap("processCode")
    public String processCode;

    /** 使用审批流模板时，流程预测结果中节点规则上必填的自选操作人列表，最大列表长度：20 */
    @NameInMap("targetSelectActioners")
    public List<StartProcessInstanceRequest.StartProcessInstanceRequestTargetSelectActioners> targetSelectActioners;
}
