package yangtz.cs.liu.dingding.utils;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.*;
import com.dingtalk.api.response.*;
import com.ruoyi.common.utils.StringUtils;
import com.taobao.api.ApiException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import yangtz.cs.liu.dingding.vo.DingSchoolRoleVo;

/**
 * 角色管理
 */
@Component
public class DingRoleUtils {

    @Autowired
    private AccessTokenUtils accessTokenUtils;

    /**
     * 创建角色
     */
    public String createRole(DingSchoolRoleVo roleVo){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/role/add_role");
            OapiRoleAddRoleRequest req = new OapiRoleAddRoleRequest();
            req.setRoleName(roleVo.getRoleName());
            req.setGroupId(roleVo.getGroupId());
            OapiRoleAddRoleResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 创建角色组
     */
    public String createRoleGroup(String name){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/role/add_role_group");
            OapiRoleAddrolegroupRequest req = new OapiRoleAddrolegroupRequest();
            req.setName(name);
            OapiRoleAddrolegroupResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 更新角色名称
     * @param roleId 角色id
     * @param roleName 角色名称
     * @return
     */
    public String updateRoleName(Long roleId, String roleName){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/role/update_role");
            OapiRoleUpdateRoleRequest req = new OapiRoleUpdateRoleRequest();
            req.setRoleId(roleId);
            req.setRoleName(roleName);
            OapiRoleUpdateRoleResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 批量增加员工角色
     */
    public String createRolesForemps(String roleIds, String userIds){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/role/addrolesforemps");
            OapiRoleAddrolesforempsRequest req = new OapiRoleAddrolesforempsRequest();
            req.setRoleIds(roleIds);
            req.setUserIds(userIds);
            OapiRoleAddrolesforempsResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 删除角色
     */
    public String deleteRole(Long roleId){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/role/deleterole");
            OapiRoleDeleteroleRequest req = new OapiRoleDeleteroleRequest();
            req.setRoleId(roleId);
            OapiRoleDeleteroleResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 批量删除员工角色
     */
    public String deleteRolesForemps(String roleIds, String userIds){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/role/removerolesforemps");
            OapiRoleRemoverolesforempsRequest req = new OapiRoleRemoverolesforempsRequest();
            req.setRoleIds(roleIds);
            req.setUserIds(userIds);
            OapiRoleRemoverolesforempsResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 设定角色成员管理范围
     * @param deptIds 部门ID列表，多个部门id之间使用逗号分隔。最多支持50个部门ID，不传则设置范围为所有人。
     * @param roleId 角色ID
     * @param userId 员工在企业中的userId
     */
    public String updateRoleScope(String deptIds, Long roleId, String userId){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/role/scope/update");
            OapiRoleScopeUpdateRequest req = new OapiRoleScopeUpdateRequest();
            req.setUserid(userId);
            req.setRoleId(roleId);
            if (StringUtils.isNotEmpty(deptIds)){
                req.setDeptIds(deptIds);
            }
            OapiRoleScopeUpdateResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 获取角色组列表
     */
    public OapiRoleGetrolegroupResponse.OpenRoleGroup getRoleGroupList(Long groupId){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/role/getrolegroup");
            OapiRoleGetrolegroupRequest req = new OapiRoleGetrolegroupRequest();
            req.setGroupId(groupId);
            OapiRoleGetrolegroupResponse rsp = client.execute(req, token);
            return rsp.getRoleGroup();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new OapiRoleGetrolegroupResponse.OpenRoleGroup();
    }

    /**
     * 获取角色列表
     */
    public OapiRoleListResponse.PageVo getRoleList(Long size, Long offset){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/role/list");
            OapiRoleListRequest req = new OapiRoleListRequest();
            if (StringUtils.isNotNull(size)){
                req.setSize(size);
            }
            if (StringUtils.isNotNull(offset)){
                req.setOffset(offset);
            }
            OapiRoleListResponse rsp = client.execute(req, token);
            return rsp.getResult();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new OapiRoleListResponse.PageVo();
    }

    /**
     * 获取角色详情
     */
    public OapiRoleGetroleResponse.OpenRole getRole(Long roleId){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/role/getrole");
            OapiRoleGetroleRequest req = new OapiRoleGetroleRequest();
            req.setRoleId(roleId);
            OapiRoleGetroleResponse rsp = client.execute(req, token);
            return rsp.getRole();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new OapiRoleGetroleResponse.OpenRole();
    }

    /**
     * 获取指定角色的员工列表
     */
    public OapiRoleSimplelistResponse.PageVo getRoleSimpleList(Long roleId,Long offset, Long size){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/role/simplelist");
            OapiRoleSimplelistRequest req = new OapiRoleSimplelistRequest();
            req.setRoleId(roleId);
            if (StringUtils.isNotNull(size)){
                req.setSize(size);
            }
            if (StringUtils.isNotNull(offset)){
                req.setOffset(offset);
            }
            OapiRoleSimplelistResponse rsp = client.execute(req, token);
            return rsp.getResult();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new OapiRoleSimplelistResponse.PageVo();
    }
}
