package yangtz.cs.liu.dingding.utils;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.DingTalkClient;
import com.dingtalk.api.request.*;
import com.dingtalk.api.response.*;
import com.ruoyi.common.utils.StringUtils;
import com.taobao.api.ApiException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import yangtz.cs.liu.dingding.vo.DingMessageVo;

/**
 * 消息通知
 */
@Component
public class DingMessageUtils {

    @Value("${dd.agentId}")
    private Long agentId;

    @Autowired
    private AccessTokenUtils accessTokenUtils;

    /**
     * 发送消息通知
     * @param messageVo
     * @return
     */
    public Long sendMessage(DingMessageVo messageVo){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2");
            OapiMessageCorpconversationAsyncsendV2Request req = new OapiMessageCorpconversationAsyncsendV2Request();
            req.setAgentId(agentId);
            if (StringUtils.isNotEmpty(messageVo.getUseridList())){
                req.setUseridList(messageVo.getUseridList());
            }
            if (StringUtils.isNotEmpty(messageVo.getDeptIdList())){
                req.setDeptIdList(messageVo.getDeptIdList());
            }
            if (StringUtils.isNotNull(messageVo.getToAllUser())){
                req.setToAllUser(messageVo.getToAllUser());
            }
            if (StringUtils.isNotNull(messageVo.getMsg())){
                req.setMsg(messageVo.getMsg());
            }
            OapiMessageCorpconversationAsyncsendV2Response rsp = client.execute(req, token);
            return rsp.getTaskId();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 撤回工作通知消息
     */
    public String recallMessage(Long taskId){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/recall");
            OapiMessageCorpconversationRecallRequest req = new OapiMessageCorpconversationRecallRequest();
            req.setAgentId(agentId);
            req.setMsgTaskId(taskId);
            OapiMessageCorpconversationRecallResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 更新工作通知状态栏
     */
    public String updateStatusBar(Long taskId, String statusValue, String statusBg){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/status_bar/update");
            OapiMessageCorpconversationStatusBarUpdateRequest req = new OapiMessageCorpconversationStatusBarUpdateRequest();
            req.setAgentId(agentId);
            req.setTaskId(taskId);
            req.setStatusValue(statusValue);
            req.setStatusBg(statusBg);
            OapiMessageCorpconversationStatusBarUpdateResponse rsp = client.execute(req, token);
            return rsp.getErrmsg();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * 获取工作通知消息的发送进度
     */
    public OapiMessageCorpconversationGetsendprogressResponse.AsyncSendProgress getSendProgress(Long taskId){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/getsendprogress");
            OapiMessageCorpconversationGetsendprogressRequest req = new OapiMessageCorpconversationGetsendprogressRequest();
            req.setAgentId(agentId);
            req.setTaskId(taskId);
            OapiMessageCorpconversationGetsendprogressResponse rsp = client.execute(req, token);
            return rsp.getProgress();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new OapiMessageCorpconversationGetsendprogressResponse.AsyncSendProgress();
    }

    /**
     * 获取工作通知消息的发送结果
     */
    public OapiMessageCorpconversationGetsendresultResponse.AsyncSendResult getSendResult(Long taskId){
        //获取access_token
        String token = accessTokenUtils.getToken();
        try {
            DingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/message/corpconversation/getsendresult");
            OapiMessageCorpconversationGetsendresultRequest req = new OapiMessageCorpconversationGetsendresultRequest();
            req.setAgentId(agentId);
            req.setTaskId(taskId);
            OapiMessageCorpconversationGetsendresultResponse rsp = client.execute(req, token);
            return rsp.getSendResult();
        } catch (ApiException e) {
            e.printStackTrace();
        }
        return new OapiMessageCorpconversationGetsendresultResponse.AsyncSendResult();
    }
}
