package yangtz.cs.liu.dingding.service.impl.dingDept;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.response.OapiV2DepartmentGetResponse;
import com.dingtalk.api.response.OapiV2DepartmentListsubResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.dingding.domain.dingDept.SysDdDept;
import yangtz.cs.liu.dingding.mapper.dingDept.DdDeptMapper;
import yangtz.cs.liu.dingding.service.dingDept.IDdDeptService;
import yangtz.cs.liu.dingding.utils.DingDeptUtils;

import java.util.ArrayList;
import java.util.List;

@Service
public class DdDeptServcieImpl implements IDdDeptService {

    @Autowired
    private DingDeptUtils dingDeptUtils;
    @Autowired
    private DdDeptMapper ddDeptMapper;

    /**
     * 获取钉钉全部部门列表
     * @return
     */
    @Override
    public List<OapiV2DepartmentListsubResponse.DeptBaseResponse> getDeptList() {
        Long deptId = 1L;
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptListAll = new ArrayList<>();
        //一级
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList = dingDeptUtils.getDeptList(deptId, "");
        for (OapiV2DepartmentListsubResponse.DeptBaseResponse response : deptList) {
            if (response.getDeptId() != -7){
                deptListAll.add(response);
                //二级
                List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList1 = dingDeptUtils.getDeptList(response.getDeptId(), "");
                if (deptList1.size() > 0) {
                    for (OapiV2DepartmentListsubResponse.DeptBaseResponse response1 : deptList1) {
                        deptListAll.add(response1);
                        //三级
                        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList2 = dingDeptUtils.getDeptList(response1.getDeptId(), "");
                        if (deptList2.size() > 0){
                            for (OapiV2DepartmentListsubResponse.DeptBaseResponse response2 : deptList2) {
                                deptListAll.add(response2);
                                //四级
                                List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList3 = dingDeptUtils.getDeptList(response2.getDeptId(), "");
                                if (deptList3.size() > 0){
                                    deptListAll.addAll(deptList3);
                                    for (OapiV2DepartmentListsubResponse.DeptBaseResponse response3 : deptList3) {
                                        //五级
                                        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList4 = dingDeptUtils.getDeptList(response3.getDeptId(), "");
                                        if (deptList4.size() > 0){
                                            deptListAll.addAll(deptList4);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return deptListAll;
    }

    /**
     * 下拉钉钉部门列表到系统
     * @return
     */
    @Override
    @Transactional
    public int addDdDept() {
        Long deptId = 1L;
        //获取部门详情
        OapiV2DepartmentGetResponse.DeptGetResponse dept = dingDeptUtils.getDept(deptId, "");
        //新增顶级目录
        SysDdDept sysDdDept = new SysDdDept();
        sysDdDept.setDeptId(100L);
        sysDdDept.setParentId(0L);
        sysDdDept.setAncestors("0");
        sysDdDept.setDeptName(dept.getName());
        sysDdDept.setOrderNum(0L);
        sysDdDept.setDdDeptId(dept.getDeptId());
        sysDdDept.setDdParentId(0L);
        sysDdDept.setCreateBy("钉钉管理员");
        ddDeptMapper.insertDdDept(sysDdDept);

        //全部部门列表
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptListAll = new ArrayList<>();

        //一级
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList = dingDeptUtils.getDeptList(deptId, "");
        for (OapiV2DepartmentListsubResponse.DeptBaseResponse response : deptList) {
            if (response.getDeptId() != -7){
                //获取部门详情
                OapiV2DepartmentGetResponse.DeptGetResponse dept1 = dingDeptUtils.getDept(response.getDeptId(), "");
                //新增一级目录
                SysDdDept sysDdDept1 = new SysDdDept();
                sysDdDept1.setParentId(sysDdDept.getDeptId());
                sysDdDept1.setAncestors("0," + sysDdDept.getDeptId());
                sysDdDept1.setDeptName(response.getName());
                sysDdDept1.setOrderNum(dept1.getOrder());
                sysDdDept1.setDdDeptId(response.getDeptId());
                sysDdDept1.setDdParentId(response.getParentId());
                sysDdDept1.setCreateBy("钉钉管理员");
                ddDeptMapper.insertDdDept(sysDdDept1);

                deptListAll.add(response);
                //二级
                List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList1 = dingDeptUtils.getDeptList(response.getDeptId(), "");
                if (deptList1.size() > 0) {
                    for (OapiV2DepartmentListsubResponse.DeptBaseResponse response1 : deptList1) {
                        //获取部门详情
                        OapiV2DepartmentGetResponse.DeptGetResponse dept2 = dingDeptUtils.getDept(response1.getDeptId(), "");
                        //新增二级目录
                        SysDdDept sysDdDept2 = new SysDdDept();
                        sysDdDept2.setParentId(sysDdDept1.getDeptId());
                        sysDdDept2.setAncestors(sysDdDept1.getAncestors() + "," + sysDdDept1.getDeptId());
                        sysDdDept2.setDeptName(response1.getName());
                        sysDdDept2.setOrderNum(dept2.getOrder());
                        sysDdDept2.setDdDeptId(response1.getDeptId());
                        sysDdDept2.setDdParentId(response1.getParentId());
                        sysDdDept2.setCreateBy("钉钉管理员");
                        ddDeptMapper.insertDdDept(sysDdDept2);

                        deptListAll.add(response1);
                        //三级
                        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList2 = dingDeptUtils.getDeptList(response1.getDeptId(), "");
                        if (deptList2.size() > 0){
                            for (OapiV2DepartmentListsubResponse.DeptBaseResponse response2 : deptList2) {
                                //获取部门详情
                                OapiV2DepartmentGetResponse.DeptGetResponse dept3 = dingDeptUtils.getDept(response2.getDeptId(), "");
                                //新增三级目录
                                SysDdDept sysDdDept3 = new SysDdDept();
                                sysDdDept3.setParentId(sysDdDept2.getDeptId());
                                sysDdDept3.setAncestors(sysDdDept2.getAncestors() + "," + sysDdDept2.getDeptId());
                                sysDdDept3.setDeptName(response2.getName());
                                sysDdDept3.setOrderNum(dept3.getOrder());
                                sysDdDept3.setDdDeptId(response2.getDeptId());
                                sysDdDept3.setDdParentId(response2.getParentId());
                                sysDdDept3.setCreateBy("钉钉管理员");
                                ddDeptMapper.insertDdDept(sysDdDept3);

                                deptListAll.add(response2);
                                //四级
                                List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList3 = dingDeptUtils.getDeptList(response2.getDeptId(), "");
                                if (deptList3.size() > 0){
                                    deptListAll.addAll(deptList3);
                                    for (OapiV2DepartmentListsubResponse.DeptBaseResponse response3 : deptList3) {
                                        //获取部门详情
                                        OapiV2DepartmentGetResponse.DeptGetResponse dept4 = dingDeptUtils.getDept(response3.getDeptId(), "");
                                        //新增四级目录
                                        SysDdDept sysDdDept4 = new SysDdDept();
                                        sysDdDept4.setParentId(sysDdDept3.getDeptId());
                                        sysDdDept4.setAncestors(sysDdDept3.getAncestors() + "," + sysDdDept3.getDeptId());
                                        sysDdDept4.setDeptName(response3.getName());
                                        sysDdDept4.setOrderNum(dept4.getOrder());
                                        sysDdDept4.setDdDeptId(response3.getDeptId());
                                        sysDdDept4.setDdParentId(response3.getParentId());
                                        sysDdDept4.setCreateBy("钉钉管理员");
                                        ddDeptMapper.insertDdDept(sysDdDept4);

                                        //五级
                                        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> deptList4 = dingDeptUtils.getDeptList(response3.getDeptId(), "");
                                        if (deptList4.size() > 0){
                                            deptListAll.addAll(deptList4);
                                            for (OapiV2DepartmentListsubResponse.DeptBaseResponse response4 : deptList4) {
                                                //获取部门详情
                                                OapiV2DepartmentGetResponse.DeptGetResponse dept5 = dingDeptUtils.getDept(response4.getDeptId(), "");
                                                //新增五级目录
                                                SysDdDept sysDdDept5 = new SysDdDept();
                                                sysDdDept5.setParentId(sysDdDept4.getDeptId());
                                                sysDdDept5.setAncestors(sysDdDept4.getAncestors() + "," + sysDdDept4.getDeptId());
                                                sysDdDept5.setDeptName(response4.getName());
                                                sysDdDept5.setOrderNum(dept5.getOrder());
                                                sysDdDept5.setDdDeptId(response4.getDeptId());
                                                sysDdDept5.setDdParentId(response4.getParentId());
                                                sysDdDept5.setCreateBy("钉钉管理员");
                                                ddDeptMapper.insertDdDept(sysDdDept5);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return 1;
    }

    /**
     * 同步钉钉部门列表
     * @return
     */
    @Override
    @Transactional
    public String syncDdDept() {
        //获取钉钉所有部门列表
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> ddDeptList = getDeptList();
        //存放钉钉部门不存在系统库集合
        List<OapiV2DepartmentListsubResponse.DeptBaseResponse> ddDeptList1 = new ArrayList<>();
        ddDeptList1.addAll(ddDeptList);

        //获取系统所有部门列表
        List<SysDdDept> deptList = ddDeptMapper.selectDdDeptList(new SysDdDept());
        //存放钉钉删除了的部门集合
        List<SysDdDept> deptList1 = new ArrayList<>();
        deptList1.addAll(deptList);

        //判断钉钉部门列表是否都在系统部门列表中
        for (OapiV2DepartmentListsubResponse.DeptBaseResponse ddDept : ddDeptList) {
            for (SysDdDept dept : deptList) {
                if (ddDept.getDeptId().equals(dept.getDdDeptId())){
                    //存在，从集合中去除
                    ddDeptList1.remove(ddDept);
                }
            }
        }

        //新增不存在系统库的部门
        if(ddDeptList1.size() > 0){
            for (OapiV2DepartmentListsubResponse.DeptBaseResponse ddDept : ddDeptList1) {
                //钉钉父部门id
                Long ddParentId = ddDept.getParentId();
                //查询父部门信息
                SysDdDept ddDept1 = ddDeptMapper.selectDeptByDdDeptId(ddParentId);
                //新增
                SysDdDept sysDdDept = new SysDdDept();
                sysDdDept.setParentId(ddDept1.getDeptId());
                sysDdDept.setAncestors(ddDept1.getAncestors() + ddDept1.getDeptId());
                sysDdDept.setDeptName(ddDept.getName());
                sysDdDept.setOrderNum(ddDept.getDeptId());
                sysDdDept.setDdDeptId(ddDept.getDeptId());
                sysDdDept.setDdParentId(ddParentId);
                sysDdDept.setCreateBy("钉钉管理员");
                ddDeptMapper.insertDdDept(sysDdDept);
            }
        }

        //判断钉钉中删除的部门是否还存在系统部门中
        for (SysDdDept dept : deptList) {
            for (OapiV2DepartmentListsubResponse.DeptBaseResponse ddDept : ddDeptList) {
                if (dept.getDdDeptId().equals(ddDept.getDeptId())){
                    deptList1.remove(dept);
                }
            }
        }
        //删除系统部门中存在的钉钉已删除的部门
        if (deptList1.size() > 0){
            for (SysDdDept dept : deptList1) {
                if (dept.getDeptId() != 100){
                    ddDeptMapper.deleteDdDeptById(dept.getDeptId());
                }
            }
        }

        //更新系统部门信息
        //获取部门详情
        OapiV2DepartmentGetResponse.DeptGetResponse djDept = dingDeptUtils.getDept(1L, "");
        //修改顶级目录
        SysDdDept dept = new SysDdDept();
        dept.setDdDeptId(djDept.getDeptId());
        dept.setDeptName(djDept.getName());
        dept.setUpdateBy("钉钉管理员");
        ddDeptMapper.updateDdDeptByDdDeptId(dept);
        for (OapiV2DepartmentListsubResponse.DeptBaseResponse ddDept : ddDeptList) {
            for (SysDdDept sysDdDept : deptList) {
                if (ddDept.getDeptId().equals(sysDdDept.getDdDeptId())){
                    //判断父部门是否发生改变
                    if (!(ddDept.getParentId().equals(sysDdDept.getDdParentId()))){
                        //钉钉父部门id
                        Long ddParentId = ddDept.getParentId();
                        //查询父部门信息
                        SysDdDept ddParentDept = ddDeptMapper.selectDeptByDdDeptId(ddParentId);
                        sysDdDept.setParentId(ddParentDept.getDeptId());
                        sysDdDept.setAncestors(ddParentDept.getAncestors() + "," + ddParentDept.getDeptId());
                        sysDdDept.setDdParentId(ddDept.getParentId());
                        sysDdDept.setUpdateBy("钉钉管理员");
                        ddDeptMapper.updateDdDeptByDdDeptId(sysDdDept);
                    }
                    //判断部门基本信息是否发生改变
                    if(!(ddDept.getName().equals(sysDdDept.getDeptName()))){
                        sysDdDept.setDeptName(ddDept.getName());
                        sysDdDept.setUpdateBy("钉钉管理员");
                        ddDeptMapper.updateDdDeptByDdDeptId(sysDdDept);
                    }
                }
            }
        }
        return "同步成功";
    }

    /**
     * 钉钉部门创建
     * @param eventJson
     * @return
     */
    @Override
    @Transactional
    public int ddDeptCreate(JSONObject eventJson) {
        int i= 0;
        String ddDeptId = eventJson.getString("DeptId");
        String replace = ddDeptId.replace("[", "");
        String deptIds = replace.replace("]", "");
        String[] split = deptIds.split(",");
        for (String deptId : split) {
            //获取部门详情
            OapiV2DepartmentGetResponse.DeptGetResponse dept = dingDeptUtils.getDept(Long.valueOf(deptId), "");
            //获取父部门信息
            Long ddParentId = dept.getParentId();
            SysDdDept sysDdDept = ddDeptMapper.selectDeptByDdDeptId(ddParentId);
            //新增部门
            SysDdDept ddDept = new SysDdDept();
            ddDept.setParentId(sysDdDept.getDeptId());
            ddDept.setAncestors(sysDdDept.getAncestors() + "," + sysDdDept.getDeptId());
            ddDept.setDeptName(dept.getName());
            ddDept.setOrderNum(dept.getOrder());
            ddDept.setDdDeptId(dept.getDeptId());
            ddDept.setDdParentId(dept.getParentId());
            ddDept.setCreateBy("钉钉管理员");
            i += ddDeptMapper.insertDdDept(ddDept);
        }
        return i;
    }

    /**
     * 钉钉部门修改
     * @param eventJson
     * @return
     */
    @Override
    public int ddDeptUpdate(JSONObject eventJson) {
        int i = 0;
        String ddDeptId = eventJson.getString("DeptId");
        String replace = ddDeptId.replace("[", "");
        String deptIds = replace.replace("]", "");
        String[] split = deptIds.split(",");
        for (String deptId : split) {
            //获取部门详情
            OapiV2DepartmentGetResponse.DeptGetResponse dept = dingDeptUtils.getDept(Long.valueOf(deptId), "");
            //获取父部门信息
            Long ddParentId = dept.getParentId();
            SysDdDept sysDdDept = ddDeptMapper.selectDeptByDdDeptId(ddParentId);
            //修改部门
            SysDdDept ddDept = new SysDdDept();
            ddDept.setParentId(sysDdDept.getDeptId());
            ddDept.setAncestors(sysDdDept.getAncestors() + "," + sysDdDept.getDeptId());
            ddDept.setDeptName(dept.getName());
            ddDept.setOrderNum(dept.getOrder());
            ddDept.setDdDeptId(dept.getDeptId());
            ddDept.setDdParentId(dept.getParentId());
            ddDept.setCreateBy("钉钉管理员");
            i += ddDeptMapper.updateDdDeptByDdDeptId(ddDept);
        }
        return i;
    }

    /**
     * 钉钉部门删除
     * @param eventJson
     * @return
     */
    @Override
    public int ddDeptDelete(JSONObject eventJson) {
        int i = 0;
        String ddDeptId = eventJson.getString("DeptId");
        String replace = ddDeptId.replace("[", "");
        String deptIds = replace.replace("]", "");
        String[] split = deptIds.split(",");
        for (String deptId : split) {
            //删除钉钉部门
            i += ddDeptMapper.deleteDdDeptByDdDeptId(Long.valueOf(deptId));
        }
        return i;
    }
}
