package yangtz.cs.liu.dingding.controller.dingEvent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.dingding.config.Constant;
import yangtz.cs.liu.dingding.service.impl.dingDept.DdDeptServcieImpl;
import yangtz.cs.liu.dingding.service.impl.dingUser.DdUserServiceImpl;
import yangtz.cs.liu.dingding.utils.DingCallbackCrypto;

import java.util.Map;

/**
 * 钉钉事件与回调
 */
@RestController
@RequestMapping("/dd/school/event")
public class DingEventController {

    private static Logger log = LoggerFactory.getLogger(DingEventController.class);

    @Autowired
    private DdDeptServcieImpl ddDeptServcie;
    @Autowired
    private DdUserServiceImpl ddUserService;

    @PostMapping("/callBack")
    public Map<String, String> callBack(
                                        @RequestParam(value = "msg_signature", required = false) String msg_signature,
                                        @RequestParam(value = "timestamp", required = false) String timeStamp,
                                        @RequestParam(value = "nonce", required = false) String nonce,
                                        @RequestBody(required = false) JSONObject json) {
        try {
            // 1. 从http请求中获取加解密参数

            // 2. 使用加解密类型
            // Constant.OWNER_KEY 说明：
            // 1、开发者后台配置的订阅事件为应用级事件推送，此时OWNER_KEY为应用的APP_KEY。
            // 2、调用订阅事件接口订阅的事件为企业级事件推送，
            //      此时OWNER_KEY为：企业的appkey（企业内部应用）或SUITE_KEY（三方应用）
            DingCallbackCrypto callbackCrypto = new DingCallbackCrypto(Constant.AES_TOKEN, Constant.AES_KEY, Constant.OWNER_KEY);
            String encryptMsg = json.getString("encrypt");
            String decryptMsg = callbackCrypto.getDecryptMsg(msg_signature, timeStamp, nonce, encryptMsg);

            // 3. 反序列化回调事件json数据
            JSONObject eventJson = JSON.parseObject(decryptMsg);
            String eventType = eventJson.getString("EventType");

            // 4. 根据EventType分类处理
            if ("check_url".equals(eventType)) {
                // 测试回调url的正确性
                log.info("测试回调url的正确性");
            } else if ("user_add_org".equals(eventType)) {
                // 处理通讯录用户增加
                ddUserService.addUser(eventJson);
            } else if ("user_modify_org".equals(eventType)) {
                // 处理通讯录用户修改
                ddUserService.updateUser(eventJson);
            } else if ("user_leave_org".equals(eventType)) {
                // 处理通讯录用户离职
                ddUserService.leaveUser(eventJson);
            } else if ("org_dept_create".equals(eventType)){
                // 处理通讯录企业部门创建
                ddDeptServcie.ddDeptCreate(eventJson);
            } else if ("org_dept_modify".equals(eventType)){
                // 处理通讯录企业部门修改
                ddDeptServcie.ddDeptUpdate(eventJson);
            } else if ("org_dept_remove".equals(eventType)){
                // 处理通讯录企业部门删除
                ddDeptServcie.ddDeptDelete(eventJson);
            } else if ("bpms_instance_change".equals(eventType)){
                // 处理审批实例事件
                log.info("发生了：" + eventType + "事件");
            } else if ("bpms_task_change".equals(eventType)){
                // 处理审批任务事件
                eventJson.get("");
            } else if ("edu_user_insert".equals(eventType)){
                // 家校人员身份新增
                ddUserService.xjUserAdd(eventJson);
            }else if ("edu_user_update".equals(eventType)){
                // 家校人员身份更新
                eventJson.get("");
            }else if ("edu_user_delete".equals(eventType)){
                // 家校人员身份删除
                eventJson.get("");
            }else if ("edu_user_relation_insert".equals(eventType)){
                // 家校人员关系新增
                eventJson.get("");
            }else if ("edu_user_relation_update".equals(eventType)){
                // 家校人员关系更新
                eventJson.get("");
            }
            else if ("edu_user_relation_delete".equals(eventType)){
                // 家校人员关系删除
                eventJson.get("");
            }else if ("edu_dept_insert".equals(eventType)){
                // 家校部门 节点新增
                eventJson.get("");
            }
            else if ("edu_dept_update".equals(eventType)){
                // 家校部门 节点更新
                eventJson.get("");
            }else if ("edu_dept_delete".equals(eventType)){
                // 家校部门 节点更新
                eventJson.get("");
            }



            else {
                // 添加其他已注册的
                log.info("发生了：" + eventType + "事件");
            }

            // 5. 返回success的加密数据
            Map<String, String> successMap = callbackCrypto.getEncryptedMap("success");
            return successMap;

        } catch (DingCallbackCrypto.DingTalkEncryptException e) {
            e.printStackTrace();
        }
        return null;
    }
}
