package yangtz.cs.liu.dingding.controller;


import cn.hutool.http.HttpUtil;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.system.mapper.SysDeptMapper;
import com.ruoyi.system.service.ISysDictDataService;
import com.ruoyi.system.service.ISysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassHeadmaster;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolCurriculum.SchoolCurriculum;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.domain.student.SchoolStudentClassRelation;
import yangtz.cs.liu.campus.domain.student.SchoolStudentClasses;
import yangtz.cs.liu.campus.domain.student.SchoolStudentParent;
import yangtz.cs.liu.campus.mapper.schoolCurriculum.SchoolCurriculumMapper;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassHeadmasterService;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassMentorService;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeMentorService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentClassRelationService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentClassesService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentParentService;
import yangtz.cs.liu.campus.service.student.ISchoolStudentService;
import yangtz.cs.liu.campus.service.teacher.ISchoolTeacherService;
import yangtz.cs.liu.campus.vo.teacher.SchoolTeacherVO;
import yangtz.cs.liu.dingding.utils.AccessTokenUtils;
import yangtz.cs.liu.dingding.vo.DingJiaXiaoVo;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 家校通讯录
 */
@RestController
@RequestMapping("/dd/djtx")
public class DingJiaXiaoController {

    private static final Logger log = LoggerFactory.getLogger(DingJiaXiaoController.class);


    @Autowired
    private AccessTokenUtils accessTokenUtils;

    final String listUrl ="https://oapi.dingtalk.com/topapi/edu/dept/list?access_token=";

    final String userUrl ="https://oapi.dingtalk.com/topapi/edu/user/list?access_token=";

   //年级表
    @Autowired
   ISchoolGradeService schoolGradeService;


    //职工与年级关系 ----------------
    @Autowired
    ISchoolGradeMentorService schoolGradeMentorService;
    //学校班级
    @Autowired
    ISchoolClassService iSchoolClassService;
    //班主任和班级关系   ------------------
    @Autowired
    ISchoolClassHeadmasterService iSchoolClassHeadmasterService;
    //任课老师和班级关系 ----------------
    @Autowired
    ISchoolClassMentorService schoolClassMentorService;
    //学生表     ---------------------
    @Autowired
    ISchoolStudentService schoolStudentService;
    //学生与班级关系 --------------------
    @Autowired
    ISchoolStudentClassRelationService iSchoolStudentClassRelationService;
    //学生历史班级表    -----------------
    @Autowired
    ISchoolStudentClassesService schoolStudentClassesService;
    //家长信息表          ---------------------
    @Autowired
    ISchoolStudentParentService iSchoolStudentParentService;
    //老师表
    @Autowired
    ISchoolTeacherService schoolTeacherService;
    //用户表        ----------------
    @Autowired
    ISysUserService sysUserService;

    @Autowired
    SysDeptMapper sysDeptMapper;

    @Autowired
    SchoolCurriculumMapper schoolCurriculumMapper;


    public List<String> userTypes = new ArrayList<String>(){
        {
            this.add("teacher");
            this.add("student");
            this.add("guardian");
        }
    };



    //更新年级与班级
    @GetMapping("/updateLabClassYear")
    private String  updateLabClassYear(){
        String token = accessTokenUtils.getToken();
        //年级
        List<SchoolGrade> schoolGradeCopies = new ArrayList<>();
        // 0 获取校园信息
        JSONObject jsonObjectParme = new JSONObject();
        jsonObjectParme.put("page_no",1);
        jsonObjectParme.put("page_size",30);
        String post = HttpUtil.post(listUrl+token, jsonObjectParme);
        JSONObject jsonObject = JSONObject.parseObject(post);
        if ((Integer) jsonObject.get("errcode") != 0){
            throw  new RuntimeException("获取校园列表失败");
        }
        Integer deptId = null;
        JSONObject result = (JSONObject)jsonObject.get("result");
        JSONArray detailsArray = JSONArray.of(result.get("details"));
        for (int i = 0 ; i < detailsArray.size(); i ++){
            JSONObject da = detailsArray.getJSONArray(i).getJSONObject(i);
            deptId = (Integer) da.get("dept_id");
        }
        //1 获取校园学历类型
        JSONObject xyParme = new JSONObject();
        xyParme.put("page_no",1);
        xyParme.put("page_size",30);
        xyParme.put("super_id",deptId);
        String xyPost = HttpUtil.post(listUrl+token, xyParme);
        JSONObject xyObject = JSONObject.parseObject(xyPost);
        if ((Integer) xyObject.get("errcode") != 0){
            throw  new RuntimeException("获取年纪列表失败");
        }
        JSONObject xyResult = (JSONObject)xyObject.get("result");
        JSONArray xyDetailsArray = JSONArray.of(xyResult.get("details"));
        for (int i = 0 ; i < xyDetailsArray.size(); i ++){
            JSONObject da = xyDetailsArray.getJSONArray(i).getJSONObject(i);
            deptId = (Integer) da.get("dept_id");
        }
        //2.获取校园年级
        JSONObject njParme = new JSONObject();
        njParme.put("page_no",1);
        njParme.put("page_size",30);
        njParme.put("super_id",deptId);
        String njPost = HttpUtil.post(listUrl+token, njParme);
        JSONObject njObject = JSONObject.parseObject(njPost);
        if ((Integer) njObject.get("errcode") != 0){
            throw  new RuntimeException("获取年纪列表失败");
        }
        JSONObject njResult = (JSONObject)njObject.get("result");
        JSONArray njDetailsArray = JSONArray.of(njResult.get("details"));
        for (int i = 0 ; i < njDetailsArray.size(); i ++) {
            for (int q = 0; q < njDetailsArray.getJSONArray(i).size(); q++) {
                JSONObject da = njDetailsArray.getJSONArray(i).getJSONObject(q);
                String grName = (String) da.get("name");
                //截取级部 2022级
                String gradeJi = grName.substring(grName.length() - 5);
                String grade = gradeJi.substring(0,gradeJi.length()-1);
                //获取年级 一年级
                String  gradeName = grName.substring(0, grName.length() - 5);
                //级部id
                Integer suId = (Integer) da.get("dept_id");
                SchoolGrade schoolGrade = new SchoolGrade();
                schoolGrade.setGradeValue(Integer.valueOf(this.gradeSubt(gradeName)));
                schoolGrade.setGradeYear(grade);
                schoolGrade.setGradeName(gradeJi+"部");
                schoolGrade.setRemark(gradeName);
                schoolGrade.setDdClassId(String.valueOf(suId));
                schoolGrade.setCreateTime(new Date());
                schoolGrade.setCreateBy("admin");
                schoolGrade.setDelFlag("0");
                schoolGrade.setUpdateBy("admin");
                schoolGrade.setUpdateTime(new Date());
                schoolGradeCopies.add(schoolGrade);
            }
        }

        //对年级进行排序 找出最新年级 设则最新学年状态  并且找出班级 进行保存
        List<SchoolGrade> collect = schoolGradeCopies.stream().sorted(Comparator.comparing(SchoolGrade::getGradeYear, Comparator.reverseOrder())).collect(Collectors.toList());
        //最新学年
        String schoolYear = collect.get(0).getGradeYear();
        for (int i = 0; i < collect.size();i++) {
            collect.get(i).setSchoolYear(schoolYear);
            if (i >= 3){
                //当前第四个以上不是新学年 更新数据库新学年状态
                List<SchoolGrade> schoolGradeCopies1 = schoolGradeService.queryList(collect.get(i));
                 if (schoolGradeCopies1.isEmpty()){
                     collect.get(i).setSfzxxn("1");
                     schoolGradeService.save(collect.get(i));
                 }else {
                     for (SchoolGrade date : schoolGradeCopies1){
                         date.setSfzxxn("1");
                         schoolGradeService.updateById(date);
                     }
                 }
                continue;
            }
            //追加学年
            List<SchoolGrade> schoolGradeCopies1 = schoolGradeService.queryList(collect.get(i));
            if (schoolGradeCopies1.isEmpty()){
                //追加
                collect.get(i).setSfzxxn("0");
                schoolGradeService.save(collect.get(i));
            }
        }
        //追加班级
        for ( SchoolGrade date: collect){
            if (date.getId()==null){
                Long l = schoolGradeService.selectDdClassId(date.getDdClassId());
                date.setId(l);
            }
             //查找班级
            //保存班级
            JSONArray ddHttp = this.getDdHttp(date.getDdClassId(), token);
            JSONArray jsonArrays = ddHttp.getJSONArray(0);
            for (int i = 0 ; i < jsonArrays.size() ; i++){
                //查询当前班级是否存在
                String classDdId = jsonArrays.getJSONObject(i).get("dept_id").toString();
                Long classId = iSchoolClassService.selectDdClassId(classDdId);
                if (null != classId){
                    SchoolClass schoolClass = new SchoolClass();
                    schoolClass.setSchoolYear(Integer.valueOf(date.getSchoolYear()));
                    schoolClass.setClassType("4");
                    schoolClass.setGradeValue(date.getGradeValue());
                    schoolClass.setGradeName(date.getGradeName());
                    schoolClass.setClassValue(Integer.valueOf(jsonArrays.getJSONObject(i).getJSONObject("feature").get("class_level").toString()));
                    String className = jsonArrays.getJSONObject(i).get("name").toString();
                    schoolClass.setClassName(className.substring(className.length()-2));
                    schoolClass.setClassAlias(jsonArrays.getJSONObject(i).get("name").toString());
                    schoolClass.setUpdateBy("admin");
                    schoolClass.setUpdateTime(new Date());
                    schoolClass.setGradeId(date.getId());
                    schoolClass.setDdClassId(classDdId);
                    schoolClass.setId(classId);
                    iSchoolClassService.updateById(schoolClass);
                }else {
                    SchoolClass schoolClass = new SchoolClass();
                    schoolClass.setSchoolYear(Integer.valueOf(date.getSchoolYear()));
                    schoolClass.setClassType("4");
                    schoolClass.setGradeValue(date.getGradeValue());
                    schoolClass.setGradeName(date.getGradeName());
                    schoolClass.setClassValue(Integer.valueOf(jsonArrays.getJSONObject(i).getJSONObject("feature").get("class_level").toString()));
                    String className = jsonArrays.getJSONObject(i).get("name").toString();
                    schoolClass.setClassName(className.substring(className.length()-2));
                    schoolClass.setClassAlias(jsonArrays.getJSONObject(i).get("name").toString());
                    schoolClass.setCreateBy("admin");
                    schoolClass.setCreateTime(new Date());
                    schoolClass.setUpdateBy("admin");
                    schoolClass.setUpdateTime(new Date());
                    schoolClass.setGradeId(date.getId());
                    schoolClass.setDdClassId(classDdId);
                    iSchoolClassService.save(schoolClass);
                }
            }
        }

        return "1";
    }


    //更新追加人员信息
    @GetMapping("/updateLabUser")
    private String updateLabUser(){
        //查找当前学年 所有的班级
        String nowSchoolYear = schoolGradeService.selectUpToYear();
        SchoolClass schoolClass = new SchoolClass();
        schoolClass.setSchoolYear(Integer.valueOf(nowSchoolYear));
        List<SchoolClass> schoolClassCopies = iSchoolClassService.selectSchoolClassList(schoolClass);
        String token = accessTokenUtils.getToken();
        for (SchoolClass date : schoolClassCopies){
            //查询班级下边的人员 包含三种人员查询
                //学生信息
                List<DingJiaXiaoVo.StudentUserInfo> studentUserInfos = new ArrayList<>();
                //老师信息
                List<DingJiaXiaoVo.StudentUserInfo> teacherUserInfos = new ArrayList<>();
                //监护人信息*
                List<DingJiaXiaoVo.StudentUserInfo> guardianUserInfos = new ArrayList<>();
                SchoolTeacherVO schoolTeacher  = new SchoolTeacherVO();
                //分页查询，每次查询数据最大只有30条，分5次查询 一个班判断最大150人
                for (String type : userTypes) {
                    if (type.equals("teacher")) {
                        //同步家校通讯老师
                        teacherUserInfos = this.addUserList(token, type, date.getDdClassId());
                        for (DingJiaXiaoVo.StudentUserInfo teachDate : teacherUserInfos){
                            // 关联老师跟班级信息
                            schoolTeacher.setTeacherName(teachDate.getName());
                            List<SchoolTeacher> schoolTeacherCopies = schoolTeacherService.selectSchoolTeacherList(schoolTeacher);
                            if (schoolTeacherCopies.isEmpty()){
                                log.error("钉钉老师未在系统中找到:"+teachDate.getName());
                                continue;
                            }
                            SchoolTeacher classHeadTeacher = schoolTeacherCopies.get(0);
                            if ("1".equals(teachDate.getIsAdviser())){
                                //当前老师是班主任 记录班主任跟班级关系
                                SchoolClassHeadmaster schoolClassHeadmaster = new SchoolClassHeadmaster();
                                schoolClassHeadmaster.setTeacherId(classHeadTeacher.getId());
                                schoolClassHeadmaster.setClassId(date.getId());
                                iSchoolClassHeadmasterService.save(schoolClassHeadmaster);
                                //设置班级 班主任信息
                                SchoolClass schoolClassss = new SchoolClass();
                                schoolClassss.setId(date.getId());
                                schoolClassss.setTeacherId(classHeadTeacher.getId());
                                schoolClassss.setTeacherName(classHeadTeacher.getTeacherName());
                                schoolClassss.setTeacherTel(classHeadTeacher.getTeacherTel());
                                iSchoolClassService.updateById(schoolClassss);
                            }else {
                                //查找部门   课程没有编写
                                SysUser sysUser = sysUserService.selectUserById(classHeadTeacher.getId());
                                String deptName = sysUser.getDept().getDeptName();
                                //根据部门查找课程信息
                                SchoolCurriculum schoolCurriculum = schoolCurriculumMapper.selectCourseName(deptName);
                                //任课老师 跟班级关系
                                SchoolClassMentor schoolClassMentor = new SchoolClassMentor();
                                schoolClassMentor.setTeacherId(classHeadTeacher.getId());
                                schoolClassMentor.setClassId(date.getId());
                                schoolClassMentor.setCourseName(schoolCurriculum.getCourseName());
                                schoolClassMentor.setCourseId(schoolCurriculum.getId());
                                schoolClassMentorService.save(schoolClassMentor);
                            }
                        }
                    } else if (type.equals("student")) {
                        //学生
                        studentUserInfos = this.addUserList(token, type, date.getDdClassId());
                        for (DingJiaXiaoVo.StudentUserInfo studentDte : studentUserInfos) {
                            //学生信息
                            SchoolStudent schoolStudent = new SchoolStudent();
                            schoolStudent.setStudentName(studentDte.getName());
                            schoolStudent.setClassId(date.getId());
                            schoolStudent.setStudentStatus("1");
                            schoolStudent.setDdUserId(studentDte.getUserId());
                            schoolStudentService.save(schoolStudent);
                            //学生班级信息
                            SchoolStudentClassRelation schoolStudentClassRelation = new SchoolStudentClassRelation();
                            schoolStudentClassRelation.setStudentId(schoolStudent.getId());
                            schoolStudentClassRelation.setClassId(date.getId());
                            iSchoolStudentClassRelationService.save(schoolStudentClassRelation);
                            //学生与班级历史关系
                            SchoolClass school= iSchoolClassService.selectSchoolClassById(date.getId());
                            SchoolStudentClasses schoolStudentClasses = new SchoolStudentClasses();
                            schoolStudentClasses.setStudentId(schoolStudent.getId());
                            schoolStudentClasses.setGrade(school.getGradeName());
                            schoolStudentClasses.setClasses(school.getClassName());
                            schoolStudentClasses.setTeacherName(school.getTeacherName());
                            schoolStudentClassesService.save(schoolStudentClasses);
                        }
                    } else if (type.equals("guardian")) {
                        //监护人
                        guardianUserInfos = this.addUserList(token, type, date.getDdClassId());
                        for (DingJiaXiaoVo.StudentUserInfo guarDate : guardianUserInfos){
                            //找寻学生
                            String toUserId = this.getToUserId(token, guarDate.getUserId(), date.getDdClassId());
                            Long ddUserId = schoolStudentService.getDdUserId(toUserId);

                            //创建用户user表
                    SysUser jUser = new SysUser();
                    jUser.setLoginName(guarDate.getName());
                    jUser.setUserName(guarDate.getName());
                    jUser.setUserType("01");
                    jUser.setUserLoginType("1");
                    jUser.setPhonenumber(guarDate.getMobile());
                    jUser.setPassword(SecurityUtils.encryptPassword("123#@!"));
                    jUser.setStatus("0");
                    jUser.setDelFlag("0");
                    jUser.setUnionId(guarDate.getUnionid());
                    jUser.setDdUserId(guarDate.getUserId());
                    jUser.setRoleIds(new Long[]{111L});
                    jUser.setStudentId(ddUserId);
                    sysUserService.insertUser(jUser);
                            //家长表
                            SchoolStudentParent schoolStudentParent = new SchoolStudentParent() ;
                            schoolStudentParent.setStudentId(ddUserId);
                            schoolStudentParent.setUserId(jUser.getUserId());
                            schoolStudentParent.setParentName(guarDate.getName());
                            schoolStudentParent.setTelephone(guarDate.getMobile());
                            Integer patriarch = this.getPatriarch(guarDate.getName().substring(guarDate.getName().length() - 2));
                            schoolStudentParent.setRelationship(String.valueOf(patriarch));
                    iSchoolStudentParentService.save(schoolStudentParent);
                        }
                    }
                }
        }



        return "完成";
    }

    //获取监护人详情 获取学生userid
    public String getToUserId(String token,String fromUserId,String classId){
        String toUserId = null;
        JSONObject bjParme = new JSONObject();
        bjParme.put("from_userid",fromUserId);
        bjParme.put("class_id",classId);
        String bjPost = HttpUtil.post("https://oapi.dingtalk.com/topapi/edu/user/relation/get?access_token="+token, bjParme);
        JSONObject bjObject = JSONObject.parseObject(bjPost);
        if ((Integer) bjObject.get("errcode") != 0){
            throw  new RuntimeException("获取班级列表失败"+bjPost);
        }
        JSONArray jsonArray = bjObject.getJSONObject("result").getJSONArray("relations");
        for (int i= 0; i<  jsonArray.size();i++){
            toUserId =  jsonArray.getJSONObject(0).get("to_userid").toString();
        }
        return toUserId;
    }


    private JSONArray  getDdHttp  (String supId,String token ){
        JSONObject bjParme = new JSONObject();
            bjParme.put("page_no",1);
            bjParme.put("page_size",30);
            bjParme.put("super_id",supId);
            String bjPost = HttpUtil.post(listUrl+token, bjParme);
            JSONObject bjObject = JSONObject.parseObject(bjPost);
            if ((Integer) bjObject.get("errcode") != 0){
                throw  new RuntimeException("获取班级列表失败");
            }
            JSONObject bjResult = (JSONObject)bjObject.get("result");
            JSONArray bjDetailsArray = JSONArray.of(bjResult.get("details"));
            return bjDetailsArray;
    }

    private List<DingJiaXiaoVo.StudentUserInfo> addUserList(String token,String type,String classId){
        List<DingJiaXiaoVo.StudentUserInfo> userList = new ArrayList<>();
        //分页查询，每次查询数据最大只有30条，分5次查询 一个班判断最大150人
        for (int k = 1;k <= 4; k++ ){
            //查询班级下边的人员
            JSONObject ryParme = new JSONObject();
            ryParme.put("page_no",k);
            ryParme.put("page_size",30);
            ryParme.put("role",type);
            ryParme.put("class_id",classId);
            String ryPost = HttpUtil.post(userUrl+token, ryParme);
            JSONObject ryObject = JSONObject.parseObject(ryPost);
            if ((Integer) ryObject.get("errcode") != 0){
                throw  new RuntimeException("获取班级人员列表失败"+ryObject.toString());
            }
            JSONObject ryResult = (JSONObject)ryObject.get("result");
            JSONArray xyDetailsArray = JSONArray.of(ryResult.get("details"));
            for (int o = 0; o < xyDetailsArray.size(); o++){
                for (int i = 0 ; i < xyDetailsArray.getJSONArray(o).size(); i++){
                    JSONObject userInfo = xyDetailsArray.getJSONArray(o).getJSONObject(i);
                    DingJiaXiaoVo.StudentUserInfo studentUserInfo = new DingJiaXiaoVo().new StudentUserInfo();
                    studentUserInfo.setUserId(userInfo.get("userid").toString());
                    studentUserInfo.setClassId((Integer) userInfo.get("class_id"));
                    studentUserInfo.setRole(userInfo.get("role")==null?null:userInfo.get("role").toString());
                    studentUserInfo.setUnionid(userInfo.get("unionid")==null?null:userInfo.get("unionid").toString());
                    studentUserInfo.setName(userInfo.get("name").toString());
                    studentUserInfo.setIsAdviser(userInfo.getJSONObject("feature").get("is_adviser") ==null ? null:userInfo.getJSONObject("feature").get("is_adviser").toString());
                    studentUserInfo.setStudentNo(userInfo.getJSONObject("feature").get("student_no") ==null ? null:userInfo.getJSONObject("feature").get("student_no").toString());
                    //学生没有手机号 不需要查询手机号
                    if (!type.equals("student")){
                        String tel = this.getTel(studentUserInfo.getUserId(), token);
                        studentUserInfo.setMobile(tel);
                    }
                    userList.add(studentUserInfo);
                }
            }
        }
        return userList;

    }


    /**
     * 钉钉数据同步到数据，
     * //班级、级部 、学生、家长、老师、班级关系、
//     */
//    @GetMapping("/updateJiaXiaoTX")
//    public void updateJiaXiaoTX(){
//
//        //获取钉钉数据
//        List<DingJiaXiaoVo> list = null;
//        //循环更新
//        for (DingJiaXiaoVo njDate :  list){
//            //更新年级
//            String gradeName = njDate.getGradeName();
//            Integer gradeId = njDate.getGradeId();
//            SchoolGrade schoolGrade = new SchoolGrade();
//            schoolGrade.setGradeName(gradeName.substring(gradeName.length()- 5)+"部");
//            schoolGrade.setGradeValue(Integer.valueOf(this.gradeSubt(gradeName.substring(3))));
//            schoolGrade.setGradeYear(gradeName.substring(gradeName.length()- 5,4));
//            schoolGrade.setSchoolYear(gradeName.substring(gradeName.length()- 5,4));
//            schoolGrade.setRemark(gradeName);
//            schoolGrade.setId(Long.valueOf(gradeId));
//            schoolGradeService.save(schoolGrade);
//            //获取班级
//            List<DingJiaXiaoVo.ClassInfo> classInfoList = njDate.getClassInfoList();
//            //遍历班级
//            for (DingJiaXiaoVo.ClassInfo classDate : classInfoList){
//
//
//                String teacherName =null;
//
//                Integer classId = classDate.getClassId();
//                String className = classDate.getClassName();
//                Map<String,String> fromUserId = this.getFromUserId(Long.valueOf(classId), accessTokenUtils.getToken());
//                SchoolClass schoolClass = new SchoolClass();
//                schoolClass.setSchoolYear(Integer.valueOf(schoolGrade.getSchoolYear()));
//                schoolClass.setClassType("4");
//                schoolClass.setGradeValue(Integer.valueOf(schoolGrade.getGradeYear()));
//                schoolClass.setGradeName(schoolGrade.getGradeName());
//                schoolClass.setId(Long.valueOf(classId));
//                schoolClass.setClassName(className);
//                schoolClass.setClassValue(Integer.valueOf(className.substring(className.length()-2,1)));
//                schoolClass.setClassAlias(className);
//                schoolClass.setGradeId(schoolGrade.getId());
//                schoolClass.setGradeId(schoolGrade.getId());
//
//                //班级
//                iSchoolClassService.save(schoolClass);
//
//                //老师
//                List<DingJiaXiaoVo.StudentUserInfo> teacherUserInfos = classDate.getTeacherUserInfos();
//                for (DingJiaXiaoVo.StudentUserInfo date : teacherUserInfos){
//                    SysUser sysUser = new SysUser();
//                    sysUser.setUserId(Long.valueOf(date.getUserId()));
////                    sysUser.setDept();  部门没有
//                    sysUser.setLoginName(date.getName());
//                    sysUser.setUserName(date.getName());
//                    sysUser.setUserType("01");
//                    sysUser.setUserLoginType("0");
//                    sysUser.setPhonenumber(date.getMobile());
//                    sysUser.setPassword(SecurityUtils.encryptPassword("123456"));
//                    sysUser.setStatus("0");
//                    sysUser.setDelFlag("0");
//                    sysUser.setUnionId(date.getUnionid());
//                    sysUser.setRoleIds(new Long[]{111L});
//                    //用户表
//                    sysUserService.insertUser(sysUser);
//
//                    SchoolTeacher schoolTeacher = new SchoolTeacher();
//                    schoolTeacher.setTeacherName(date.getName());
//                    // schoolTeacher.setSex(); 性别没有
//                    schoolTeacher.setNation("汉族");
////                    schoolTeacher.setTeacherCode();  工作编号
//                    schoolTeacher.setUserId(sysUser.getUserId());
//                    schoolTeacher.setTeacherTel(date.getMobile());
//                    schoolTeacher.setUnionId(date.getUnionid());
//                    //  schoolTeacher.setDeptId(); schoolTeacher.setDeptName();  部门没有
//                    //老师表
//                    schoolTeacherService.save(schoolTeacher);
//                    //老师与班级关系表 缺少课程信息
////                    SchoolClassMentor schoolClassMentor = new SchoolClassMentor();
////                    schoolClassMentor.setTeacherId(schoolTeacher.getId());
////                    schoolClassMentorService.save(schoolClassMentor);
//                    if (date.getIsAdviser().equals("1")){
//                          schoolClass.setTeacherId(schoolTeacher.getId());
//                         schoolClass.setTeacherName(date.getName());
//                         schoolClass.setTeacherTel(date.getMobile());
//                        teacherName =  date.getName();
//                        SchoolClassHeadmaster schoolClassHeadmaster = new SchoolClassHeadmaster();
//                        schoolClassHeadmaster.setTeacherId(schoolTeacher.getId());
//                        schoolClassHeadmaster.setClassId(Long.valueOf(classId));
//                        //班主任和班级关系
//                        iSchoolClassHeadmasterService.save(schoolClassHeadmaster);
//                    }
//                }
//
//                //学生
//                List<DingJiaXiaoVo.StudentUserInfo> studentUserInfos = classDate.getStudentUserInfos();
//                for (DingJiaXiaoVo.StudentUserInfo date : studentUserInfos){
//                    //学生表
//                    SchoolStudent schoolStudent = new SchoolStudent();
//                    schoolStudent.setStudentName(date.getName());
////                    schoolStudent.setSex();
//                    schoolStudent.setClassId(Long.valueOf(classId));
////                    schoolStudent.setIdCard(); 身份证号
//                    schoolStudent.setNation("汉族");
//                    schoolStudent.setNationalNumber(date.getStudentNo());
//                    schoolStudent.setEnrollmentYear(gradeName.substring(gradeName.length()- 5,4));
//                    schoolStudent.setStudentStatus("1");
//                    schoolStudent.setId(Long.valueOf(date.getUserId()));
//                    schoolStudentService.save(schoolStudent);
//                    //学生与班级关系
//                    SchoolStudentClassRelation schoolStudentClassRelation = new SchoolStudentClassRelation();
//                    schoolStudentClassRelation.setClassId(Long.valueOf(classId));
//                    schoolStudentClassRelation.setStudentId(schoolStudent.getId());
//                    iSchoolStudentClassRelationService.save(schoolStudentClassRelation);
//                    //学生历史班级表
//                    SchoolStudentClasses schoolStudentClasses = new SchoolStudentClasses();
//                    schoolStudentClasses.setTeacherName(teacherName);
//                    schoolStudentClasses.setStudentId(schoolStudent.getId());
//                    schoolStudentClasses.setGrade(gradeName.substring(gradeName.length()- 5,4));
//                    schoolStudentClasses.setClasses(className);
//                    schoolStudentClassesService.save(schoolStudentClasses);
//                }
//                //监护人
//                List<DingJiaXiaoVo.StudentUserInfo> guardianUserInfos = classDate.getGuardianUserInfos();
//                for (DingJiaXiaoVo.StudentUserInfo date : guardianUserInfos){
//                    String studentId = fromUserId.get(date.getUserId());
//
//                    //创建家长用户
//                    SysUser jUser = new SysUser();
//                    jUser.setUserId(Long.valueOf(date.getUserId()));
////                    sysUser.setDept();  部门没有
//                    jUser.setLoginName(date.getName());
//                    jUser.setUserName(date.getName());
//                    jUser.setUserType("01");
//                    jUser.setUserLoginType("1");
//                    jUser.setPhonenumber(date.getMobile());
//                    jUser.setPassword(SecurityUtils.encryptPassword("123456"));
//                    jUser.setStatus("0");
//                    jUser.setDelFlag("0");
//                    jUser.setUnionId(date.getUnionid());
//                    jUser.setRoleIds(new Long[]{111L});
//                    jUser.setStudentId(Long.valueOf(studentId));
//                    sysUserService.insertUser(jUser);
//                    //维护家长表
//                    SchoolStudentParent schoolStudentParent = new SchoolStudentParent();
//                    schoolStudentParent.setStudentId(Long.valueOf(studentId));
//                    schoolStudentParent.setUserId(jUser.getUserId());
//                    schoolStudentParent.setParentName(date.getName());
//                    schoolStudentParent.setTelephone(date.getMobile());
//                    Integer patriarch = this.getPatriarch(date.getName().substring(date.getName().length() - 2));
//                    schoolStudentParent.setRelationship(patriarch.toString());
//                    iSchoolStudentParentService.save(schoolStudentParent);
//
//                }
//
//
//                iSchoolClassService.updateById(schoolClass);
//
//
//            }
//        }
//    }


    private String gradeSubt(String grade){
        String gId = null;
        switch (grade){
            case  "一年级": return  gId = "1";
            case  "二年级": return  gId = "2";
            case  "三年级": return  gId = "3";
            case  "四年级": return  gId = "4";
            case  "五年级": return  gId = "5";
            case  "六年级": return gId = "6";
            case  "七年级": return gId = "7";
            case  "八年级": return gId = "8";
            case  "九年级": return gId = "9";
            case  "十年级": return gId = "10";
            case  "十一年级": return gId = "11";
            case  "十二年级": return gId = "12";
            case  "十三年级": return gId = "13";
            case  "十四年级": return gId = "14";
            case  "十五年级": return gId = "15";
            case  "十六年级": return gId = "16";
            case  "十七年级": return gId = "17";
            case  "十八年级": return gId = "18";
            case  "十九年级": return gId = "19";
            case  "二十年级": return gId = "20";
            case  "二十一年级": return gId = "21";
            case  "二十二级": return gId = "22";
            case  "二十三年级": return gId = "23";
            case  "二十四年级": return gId = "24";
            case  "二十五年级": return gId = "25";
            case  "二十六年级": return gId = "26";
            case  "二十七年级": return gId = "27";
            case  "二十八年级": return gId = "28";
            case  "二十九年级": return gId = "29";
            case  "三十年级": return gId = "30";

        }
        return gId;
    }
    private Integer getPatriarch(String patriarch){
        Integer gId = null;
        switch (patriarch){
            case  "爸爸": return gId = 0;
            case  "妈妈": return gId = 1;
            case  "爷爷": return gId = 2;
            case  "奶奶": return gId = 3;
            case  "叔叔": return gId = 4;
            case  "姑姑": return gId = 5;
            case  "外婆": return gId = 6;
            case  "外公": return gId = 7;
            case  "哥哥": return gId = 8;
            case  "姐姐": return gId = 9;
            case  "阿姨": return gId = 10;
            case  "家长": return gId = 11;
        }
        return gId;
    }

    /**
     * 调用钉钉公共接口，获取用户手机号
     */
    public String getTel(String userId ,String assToKen){
        JSONObject userParme = new JSONObject();
        userParme.put("userid",userId);
        String userPost = HttpUtil.post("https://oapi.dingtalk.com/topapi/v2/user/get?access_token="+assToKen, userParme);
        JSONObject jsonObject = JSONObject.parseObject(userPost);

        if (jsonObject.getJSONObject("result").get("mobile")==null){
            return null;
        }else {
            return jsonObject.getJSONObject("result").get("mobile").toString();
        }
    }

    /**
     * 获取班级 家 学关系
     */
    public Map<String,String> getFromUserId(Long classId ,String assToKen){
        Map<String,String> map = new HashMap();
        JSONObject userParme = new JSONObject();
        userParme.put("class_id",classId);
        String userPost = HttpUtil.post("https://oapi.dingtalk.com/topapi/edu/user/relation/list?access_token="+assToKen, userParme);
        JSONObject jsonObject = JSONObject.parseObject(userPost);
        JSONArray jsonArray = jsonObject.getJSONObject("result").getJSONArray("relations");
        for (int i =0 ; i< jsonArray.size(); i++ ){
            JSONObject jsonDate= jsonArray.getJSONObject(i);
            String fromUserid = jsonDate.get("from_userid").toString();
            String toUserid = jsonDate.get("to_userid").toString();
            map.put(fromUserid,toUserid);
        }
        return map;
    }
}
