package yangtz.cs.liu.campus.vo.teacher;

import com.baomidou.mybatisplus.annotation.TableName;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.system.domain.SysPost;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
public class SchoolTeacherVO extends OurBaseEntity {

    /**
     * 老师名称
     */
    @Excel(name = "老师名字")
    @NotBlank(message = "老师名字不能为空")
    private String teacherName;

    /**
     * 性别
     */
    @Excel(name = "性别")
//    @NotBlank(message = "性别不能为空")
    private String sex;

    /**
     * 身份证
     */
    @Excel(name = "身份证")
//    @NotBlank(message = "身份证不能为空")
    private String idCard;

    /**
     * 老师电话
     */
    @Excel(name = "老师电话")
    @NotBlank(message = "老师电话不能为空")
    private String teacherTel;

    /**
     * 工作编号
     */
    @Excel(name = "工作编号")
    private String teacherCode;

    /**岗位id**/
    private Long[] postIds;

    /**岗位名称**/
    private String postName;

    /** 部门id */
    private Long[] deptIds;

    /** 部门名称 */
    private String deptNames;

    /**
     * 生日
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "生日", width = 30, dateFormat = "yyyy-MM-dd")
    private Date birthday;

    /**
     * 学历
     */
    @Excel(name = "学历")
    private String education;

    /**
     * 照片路径
     */
    private String picUrl;

    /**角色id**/
    private Long[] roleIds;

    /**角色名称**/
    private String roleName;

    /**
     * 民族
     */
    @Excel(name = "民族")
    private String nation;

    /**
     * 住址
     */
    @Excel(name = "住址")
    private String homeAddress;


    /**微信openid**/
    private String openId;

    /**部门id**/
    //@NotNull(message = "部门不能为空")
    private Long deptId;

    /**部门名称**/
    private String deptName;

    /** 密码 */
    private String password;

    private Long userId;

    private String ddUserId;


    private String unionId;

    /** 帐号状态（0正常 1停用） */
    //@Excel(name = "帐号状态", readConverterExp = "0=正常,1=停用")
    private String status;

    /**签名路径*/
    private String sign;

    /**头像*/
    private String avatar;

    /**用户邮箱*/
    private String email;

    /**备注*/
    private String remark;

    //用户登录类型
    private String userLoginType;

    /** 职工类型（0教工，1职工） */
    private String employeeType;

    //设备工号
    private String deviceNum;

    /**传授课程**/
    private String courseName;

}
