package yangtz.cs.liu.campus.vo.teacher;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import java.util.Date;

@Data
public class SchoolTeacherOvertimeVO extends ProcessBaseEntity {

    private Long id;
    /**
     * 教师id
     */
    private Long teacherId;

    /**
     * 教师姓名
     */
    @Excel(name = "教师姓名")
    private String teacherName;

    /**
     * 所在部门
     */
    // @Excel(name = "所在部门")
    // private String department;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 加班天数
     */
    @Excel(name = "加班天数")
    private String days;

    /**
     * 加班原因
     */
    @Excel(name = "加班原因")
    private String reason;

    /**
     * 状态
     */
    private String state;
    /**
     * 流程实例ID
     **/
    private String instanceId;
    /**
     * 类型
     **/
    private String type;
    /**
     * 申请人姓名
     **/
    private String applyUser;

    /**
     * 实际开始时间
     */
    private Date realityStartTime;
    /**
     * 实际结束时间
     */
    private Date realityEndTime;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;
}
