package yangtz.cs.liu.campus.vo.student;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class SchoolStudentVO {

    private Long id;

    /**图片路径**/
    //@Excel(name = "图片路径",cellType = Excel.ColumnType.IMAGE)
    private String avatar;

    /**学生姓名**/
    @Excel(name = "*学生姓名")
    @NotBlank(message = "学生姓名不能为空")
    private String studentName;

    /**身份证号**/
    @Excel(name = "*身份证号",width = 25)
//    @NotBlank(message = "身份证号不能为空")
    private String idCard;

    /**性别**/
    @Excel(name = "学生性别",combo = {"男","女"},readConverterExp = "0=男,1=女")
//    @NotBlank(message = "学生性别不能为空")
    private String sex;

    /**民族**/
    @Excel(name = "*学生民族",combo = {"汉族","壮族","回族","满族","维吾尔族","苗族","彝族","土家族","藏族",
            "蒙古族","侗族","布依族","瑶族","白族","朝鲜族","哈尼族","黎族","哈萨克族","傣族","畲族","傈僳族","东乡族",
            "仡佬族","拉祜族","佤族","水族","纳西族","羌族","土族","仫佬族","锡伯族","柯尔克孜族","景颇族","达斡尔族",
            "撒拉族","布朗族","毛南族","塔吉克族","普米族","阿昌族","怒族","鄂温克族","京族","基诺族","德昂族","保安族",
            "俄罗斯族","裕固族","乌孜别克族","门巴族","鄂伦春族","独龙族","赫哲族","高山族","珞巴族","塔塔尔族"},width = 25)
    //@NotBlank(message = "学生民族不能为空")
    private String nation;

    /**班级id**/
    private Long classId;

    /**籍贯**/
    @Excel(name = "*籍贯",width = 25)
    private String nativePlace;

    /**出生日期**/
//    @NotNull(message = "出生日期不能为空")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出生日期", dateFormat = "yyyy-MM-dd",width = 25)
    private Date birthday;

    /**学生状态**/
//    @Excel(name = "学生状态", readConverterExp = "1=正常,2=休学,3=毕业,4=肄业,5=毕业,6=其他")
    @Excel(name = "*学生状态",combo = {"正常","休学","毕业","肄业","退学","其他"},readConverterExp = "1=正常,2=休学,3=毕业,4=肄业,5=退学,6=其他")
    private String studentStatus;

    /**学生类型**/
//    @Excel(name = "学生类型",readConverterExp = "1=本校生,2=借读生")
    @Excel(name = "*学生类型",combo = {"本校生","借读生"},readConverterExp = "1=本校生,2=借读生")
    private String studentType;

    /**注册序号**/
    @Excel(name = "*注册序号",width = 25)
    @NotBlank(message = "注册序号不能为空")
    private String schoolNo;

    /** 省学籍辅号 */
    @Excel(name = "*省学籍辅号",width = 25)
    private String provincialNumber;

    /**当前学年**/
    @Excel(name = "*当前学年", cellType = Excel.ColumnType.NUMERIC)
    private Integer schoolYear;

    /**年级**/
    @Excel(name = "*年级",combo = {"一年级","二年级","三年级"},readConverterExp = "1=一年级,2=二年级,3=三年级", cellType = Excel.ColumnType.NUMERIC)
    private Integer gradeValue;
    private String gradeName;

    /**班级**/
    @Excel(name = "*班级",combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"},
            readConverterExp = "1=一班,2=二班,3=三班,4=四班,5=五班,6=六班,7=七班,8=八班,9=九班,10=十班,11=十一班," +
                    "12=十二班,13=十三班,14=十四班,15=十五班,16=十六班,17=十七班,18=十八班,19=十九班,20=二十班," +
                    "21=二十一班,22=二十二班,23=二十三班,24=二十四班,25=二十五班,26=二十六班,27=二十七班,28=二十八班,29=二十九班,30=三十班,31=三十一班,32=三十二班",
            cellType = Excel.ColumnType.NUMERIC)
    private Integer classValue;
    private String className;

    /** 级，如2021级 */
    @Excel(name = "级")
    private String enrollmentYear;

    /** 联系电话 */
    @Excel(name = "联系电话",width = 25)
    private String stuTelephone;


    /** 邮政编码 */
    @Excel(name = "邮政编码")
    private String postalCode;

    /** 性质(0普通 1音乐 2 体育 3美术 4书法)*/
    @Excel(name = "性质",combo = {"普通","音乐","体育","美术","书法"},readConverterExp = "0=普通,1=音乐,2=体育,3=美术,4=书法")
    private String nature;



    /** 全国学籍号 */
    @Excel(name = "全国学籍号",width = 25)
    private String nationalNumber;


    /** 入学时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "入学时间",width = 25,dateFormat = "yyyy-MM-dd")
    private Date enrollmentTime;

    /** 平台 */
    @Excel(name = "平台",width = 25)
    private String platform;


    /**现住地址**/
    @Excel(name = "现住地址",width = 30)
    private String homeAddress;

    /** 出生地 */
    @Excel(name = "出生地",width = 30)
    private String birthAddress;

    /** 通讯地址 */
    @Excel(name = "通讯地址",width = 30)
    private String postalAddress;

    /** 户口所在地 */
    @Excel(name = "户口所在地",width = 25)
    private String registeredAddress;

    /** 户口性质 */
    @Excel(name = "户口性质",combo = {"农业户口","非农户口"},readConverterExp = "0=农业户口,1=非农户口")
    private String registeredType;

    /** 初中学校 */
    @Excel(name = "初中学校",width = 25)
    private String juniorSchool;

    /** 国家地区（0否 1是） */
    @Excel(name = "国家地区",width = 25)
    private String region;

    /** 外语语种（0否 1是） */
    @Excel(name = "外语语种")
    private String foreignLanguages;

    /** 政治面貌 */
    @Excel(name = "政治面貌",combo = {"中共党员","共青团员","群众"},readConverterExp = "0=中共党员,1=共青团员,2=群众")
    private String appearance;

    /** 血型 */
    @Excel(name = "血型")
    private String bloodType;

    /** 健康状况（0否 1是） */
    @Excel(name = "健康状况")
    private String health;

    /** 港澳台侨 */
    @Excel(name = "港澳台侨")
    private String otherRegions;

    /** 流动人口状况 */
    @Excel(name = "流动人口状况",width = 25)
    private String floatingPopulation;

    /** 接收资助状况 */
    @Excel(name = "接收资助状况",width = 25)
    private String support;

    //独生子女（0否 1是）
    @Excel(name = "独生子女",combo = {"否","是"},readConverterExp = "0=否,1=是")
    private String onlyChild;


    /**校园一卡通**/
    @Excel(name = "校园一卡通",width = 25)
    private String oneCard;

    private String classAlias;

    /** 家长姓名1 */
    @Excel(name = "家长姓名1")
    private String parentName1;

    /** 家长关系1 */
    @Excel(name = "家长关系1",combo = {"父亲","母亲","爷爷","奶奶","叔叔","姑姑"},readConverterExp = "0=父亲,1=母亲,2=爷爷,3=奶奶,4=叔叔,5=姑姑")
    private String relationship1;

    /**家长工作单位1**/
    @Excel(name = "家长工作单位1",width = 25)
    private String workAddress1;

    /**家长联系地址1**/
    @Excel(name = "家长联系地址1",width = 25)
    private String contactAddress1;

    /** 家长联系电话1 */
    @Excel(name = "家长联系电话1",width = 25)
    private String telephone1;

    /** 家长邮政编码1 */
    @Excel(name = "家长邮政编码1")
    private String postalCode1;

    /** 家长姓名2 */
    @Excel(name = "家长姓名2")
    private String parentName2;

    /** 家长关系2 */
    @Excel(name = "家长关系2",combo = {"父亲","母亲","爷爷","奶奶","叔叔","姑姑"},readConverterExp = "0=父亲,1=母亲,2=爷爷,3=奶奶,4=叔叔,5=姑姑")
    private String relationship2;

    /**家长工作单位2**/
    @Excel(name = "家长工作单位2",width = 25)
    private String workAddress2;

    /**家长联系地址2**/
    @Excel(name = "家长联系地址2",width = 25)
    private String contactAddress2;

    /** 家长联系电话2 */
    @Excel(name = "家长联系电话2",width = 25)
    private String telephone2;

    /** 家长邮政编码2 */
    @Excel(name = "家长邮政编码2")
    private String postalCode2;

   /* *//** 家长姓名3 *//*
    @Excel(name = "家长姓名3")
    private String parentName3;

    *//** 家长关系3 *//*
    @Excel(name = "家长关系3",combo = {"父亲","母亲","爷爷","奶奶","叔叔","姑姑"},readConverterExp = "0=父亲,1=母亲,2=爷爷,3=奶奶,4=叔叔,5=姑姑")
    private String relationship3;

    *//**家长工作单位3**//*
    @Excel(name = "家长工作单位3")
    private String workAddress3;

    *//**家长联系地址3**//*
    @Excel(name = "家长联系地址3")
    private String contactAddress3;

    *//** 家长联系电话3 *//*
    @Excel(name = "家长联系电话3")
    private String telephone3;

    *//** 家长邮政编码3 *//*
    @Excel(name = "家长邮政编码3")
    private String postalCode3;

    *//** 家长姓名4 *//*
    @Excel(name = "家长姓名4")
    private String parentName4;

    *//** 家长关系4 *//*
    @Excel(name = "家长关系4",combo = {"父亲","母亲","爷爷","奶奶","叔叔","姑姑"},readConverterExp = "0=父亲,1=母亲,2=爷爷,3=奶奶,4=叔叔,5=姑姑")
    private String relationship4;

    *//**家长工作单位4**//*
    @Excel(name = "家长工作单位4")
    private String workAddress4;

    *//**家长联系地址4**//*
    @Excel(name = "家长联系地址4")
    private String contactAddress4;

    *//** 家长联系电话4 *//*
    @Excel(name = "家长联系电话4")
    private String telephone4;

    *//** 家长邮政编码4 *//*
    @Excel(name = "家长邮政编码4")
    private String postalCode4;*/


    /**家长身份证号**/
    //@Excel(name = "家长身份证号",width = 25)
    private String pidCard;

    //当前学年，当前学期的积分
    private Double score;

    //教务-学生管理-学籍表-所在年级
    private String currentGrade;
    private String ddUserId;
}
