package yangtz.cs.liu.campus.vo.student;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

/**
 * 学生成绩对象vo
 */
@Data
public class SchoolStudentScoreVo extends OurBaseEntity {


    private Long id;
    /** 学生主键id */
    private Long studentId;
    /** 选课主键id */
    private Long curriculaId;
    /** 班级主键id */
    private Long classId;
    /** 学生姓名 */
    @Excel(name = "*学生姓名")
    private String studentName;
    /** 学号 */
    @Excel(name = "*学号")
    private String studentNumber;
    /** 身份证号 */
    @Excel(name = "*身份证号")
    private String idCard;
    /** 班级 */
    @Excel(name = "班级")
    private String className;
    /**年级值*/
    private Integer gradeValue;
    /** 考试类型 */
    @Excel(name = "*考试类型",combo = {"一次","二次","三次","期末"},readConverterExp = "1=一次,2=二次,3=三次,4=期末")
    private String examType;
    /** 总成绩 */
    private double totalScore;
    /** 总成绩年级排名 */
    private Integer ranking;
    /** 班级排名 */
    private Integer classRanking;
    /** 语文 */
    @Excel(name = "语文")
    private double language;
    /** 年级排名 */
    private Integer ywRanking;
    /** 班级排名 */
    private Integer ywClassRanking;
    /** 数学 */
    @Excel(name = "数学")
    private double math;
    /** 年级排名 */
    private Integer sxRanking;
    /** 班级排名 */
    private Integer sxClassRanking;
    /** 英语 */
    @Excel(name = "英语")
    private double english;
    /** 年级排名 */
    private Integer yyRanking;
    /** 班级排名 */
    private Integer yyClassRanking;
    /** 政治 */
    @Excel(name = "政治")
    private double politics;
    /** 年级排名 */
    private Integer zzRanking;
    /** 班级排名 */
    private Integer zzClassRanking;
    /** 地理 */
    @Excel(name = "地理")
    private double geography;
    /** 年级排名 */
    private Integer dlRanking;
    /** 班级排名 */
    private Integer dlClassRanking;
    /** 历史 */
    @Excel(name = "历史")
    private double history;
    /** 年级排名 */
    private Integer lsRanking;
    /** 班级排名 */
    private Integer lsClassRanking;
    /** 物理 */
    @Excel(name = "物理")
    private double physics;
    /** 年级排名 */
    private Integer wlRanking;
    /** 班级排名 */
    private Integer wlClassRanking;
    /** 化学 */
    @Excel(name = "化学")
    private double chemistry;
    /** 年级排名 */
    private Integer hxRanking;
    /** 班级排名 */
    private Integer hxClassRanking;
    /** 生物 */
    @Excel(name = "生物")
    private double biology;
    /** 年级排名 */
    private Integer swRanking;
    /** 班级排名 */
    private Integer swClassRanking;



    public double getTotalScore() {
        return totalScore;
    }

    public void setTotalScore(double totalScore) {
        this.totalScore = totalScore;
    }
}
