package yangtz.cs.liu.campus.vo.schoolcalendar;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class SchoolCalendarDetailVo extends OurBaseEntity {

    private static final long serialVersionUID = 1L;
    /** 校历表id */
    @Excel(name = "校历表id")
    private Long calendarId;

    /** 校历名称 */
    @Excel(name = "校历表名称")
    private String calendarName;

    /** 详细条目名称 */
    @Excel(name = "详细条目名称")
    private String detailName;

    /** 内容 */
    @Excel(name = "内容")
    private String detailContent;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 节假日名称 */
    @Excel(name = "节假日名称")
    private String holidayName;

    /** 星期数值 */
    @Excel(name = "星期数值")
    private Long weekValue;

    /** 星期 */
    @Excel(name = "星期")
    private String weekName;

    /** 日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date calendarDate;


}
