package yangtz.cs.liu.campus.vo.schoolLab;

import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolExperimentPlanClass;

/**
 * 实验计划对象Vo
 *
 * @author ruoyi
 * @date 2023-08-29
 */
@Data
public class SchoolExperimentPlanVo extends BaseEntity
{
    /** 实验计划主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 学科（1物理，2化学，3生物） */
    @Excel(name = "学科", combo = {"物理","化学","生物"}, readConverterExp = "1=物理,2=化学,3=生物")
    private String sub;

    private List<String> subs;

    /** 级部id */
    private Long gradeId;

    private List<Long> gradeIds;

    /** 级部 */
    @Excel(name = "级部")
    private String grade;

    /** 学年 */
    @Excel(name = "学年")
    private String schoolYear;

    /** 学年+学期 */
    private String schoolYearSemester;

    /** 学期（1上学期，2下学期） */
    @Excel(name = "学期", combo = {"上学期","下学期"}, readConverterExp = "1=上学期,2=下学期")
    private String semester;

    /** 实验分类（1分组实验，2演示实验，3探究实验） */
    @Excel(name = "实验分类", combo = {"分组实验","演示实验","探究实验"}, readConverterExp = "1=分组实验,2=演示实验,3=探究实验")
    private String experimentClassify;

    /** 实验名称 */
    @Excel(name = "实验名称")
    private String experimentName;

    /** 章节内容 */
    @Excel(name = "章节内容")
    private String chapterContent;

    /** 是否已预约 */
    @Excel(name = "是否已预约", combo = {"是","否"}, readConverterExp = "0=否,1=是")
    private String isAppointment;

    /** 计划开始时间 */
    @Excel(name = "计划开始时间")
    private String plannedStartTime;

    /** 计划结束时间 */
    @Excel(name = "计划结束时间")
    private String plannedEndTime;

    /** 计划时间 */
    private String plannedTime;

    /** 实验用品 */
    @Excel(name = "实验用品")
    private String experimentUseGoods;

    /** 实验计划与班级关系信息 */
    private List<SchoolExperimentPlanClass> schoolExperimentPlanClassList;
}
