package yangtz.cs.liu.campus.vo.schoolLab;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolExperimentPlanClass;

import java.util.List;

@Data
public class SchoolExperimentPlanMbVo extends BaseEntity {

    /** 实验计划主键id */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /** 级部 */
    @Excel(name = "级部")
    private String grade;

    /** 学年 */
    @Excel(name = "学年")
    private String schoolYear;

    /** 学期（1上学期，2下学期） */
    @Excel(name = "学期", combo = {"上学期","下学期"}, readConverterExp = "1=上学期,2=下学期")
    private String semester;

    /** 学科（1物理，2化学，3生物） */
    @Excel(name = "学科", combo = {"物理","化学","生物"}, readConverterExp = "1=物理,2=化学,3=生物")
    private String sub;

    private List<String> subs;

    /** 级部id */
    private Long gradeId;

    private List<Long> gradeIds;

    /** 学年+学期 */
    private String schoolYearSemester;

    /** 实验分类（1分组实验，2演示实验，3探究实验） */
    @Excel(name = "实验分类", combo = {"分组实验","演示实验","探究实验"}, readConverterExp = "1=分组实验,2=演示实验,3=探究实验")
    private String experimentClassify;

    /** 实验名称 */
    @Excel(name = "实验名称")
    private String experimentName;

    /** 章节内容 */
    @Excel(name = "章节内容")
    private String chapterContent;

    /** 是否已预约 */
    private String isAppointment;

    /** 计划开始时间 */
    @Excel(name = "计划开始时间")
    private String plannedStartTime;

    /** 计划结束时间 */
    @Excel(name = "计划结束时间")
    private String plannedEndTime;

    /** 计划时间 */
    private String plannedTime;

    /** 实验用品 */
    @Excel(name = "实验用品")
    private String experimentUseGoods;

    private Long classId1;
    @Excel(name = "班级名称1", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className1;

    private Long classId2;
    @Excel(name = "班级名称2", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className2;

    private Long classId3;
    @Excel(name = "班级名称3", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className3;

    private Long classId4;
    @Excel(name = "班级名称4", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className4;

    private Long classId5;
    @Excel(name = "班级名称5", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className5;

    private Long classId6;
    @Excel(name = "班级名称6", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className6;

    private Long classId7;
    @Excel(name = "班级名称7", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className7;

    private Long classId8;
    @Excel(name = "班级名称8", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className8;

    private Long classId9;
    @Excel(name = "班级名称9", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className9;

    private Long classId10;
    @Excel(name = "班级名称10", combo = {"一班","二班","三班","四班","五班","六班","七班","八班","九班","十班","十一班","十二班","十三班",
            "十四班","十五班","十六班","十七班","十八班","十九班","二十班","二十一班","二十二班","二十三班","二十四班",
            "二十五班","二十六班","二十七班","二十八班","二十九班","三十班","三十一班","三十二班"})
    private String className10;

    /** 实验计划与班级关系信息 */
    private List<SchoolExperimentPlanClass> schoolExperimentPlanClassList;
}
