package yangtz.cs.liu.campus.vo.schoolEquipment;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

/**
 * 设备领用对象 school_receive
 *
 * @author ruoyi
 * @date 2023-08-09
 */
@Data
public class SchoolReceiveVo extends BaseEntity
{
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long adminId;

    /** 设备id */
    private Long equipmentId;

    /** 自编码 */
    @Excel(name = "自编码")
    private String encode;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String equipmentName;

    /** 型号 */
    @Excel(name = "型号")
    private String model;

    /** 领用日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "领用日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date recipientTime;

    /** 领用人id */
    private String recipientById;

    /** 领用人 */
    @Excel(name = "领用人")
    private String recipientBy;

    /** 退还状态(0=未退还，1=已退还)" */
    @Excel(name = "退还状态", readConverterExp = "1=已退还,0=未退还")
    private String returnState;

    /** 退还日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "退还日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date returnTime;

    /** 退还时设备情况 */
    @Excel(name = "退还时设备情况")
    private String returnEquipmentCondition;

    /** 接收人id */
    private Long receivedById;

    /** 接收人 */
    @Excel(name = "接收人")
    private String receivedBy;

    /** 预计使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预计使用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date yjuseTime;

    /** 实际使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "实际使用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date sjuseTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;
}
