package yangtz.cs.liu.campus.vo.schoolEquipment;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;

/**
 * 设备借出归还对象 school_circulation
 *
 * @author ruoyi
 * @date 2023-08-09
 */
@Data
public class SchoolCirculationVo extends BaseEntity
{

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    private Long adminId;

    /** 设备id */
    private Long equipmentId;

    /** 自编码 */
    @Excel(name = "自编码")
    private String encode;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String equipmentName;

    /** 型号 */
    @Excel(name = "型号")
    private String model;

    /** 借用日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "借用日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date borrowTime;

    /** 借用人id */
    private Long borrowById;

    /** 借用人 */
    @Excel(name = "借用人")
    private String borrowBy;

    /** 用途 */
    @Excel(name = "用途")
    private String purpose;

    /** 借用期限（天） */
    @Excel(name = "借用期限(天)")
    private Long deadline;

    /** 归还状态(0=未归还，1=已归还)" */
    @Excel(name = "归还状态", readConverterExp = "1=已归还,0=未归还")
    private String returnState;

    /** 是否已借出（1是，0否） */
    @Excel(name = "是否已借出", readConverterExp = "1=是,0=否")
    private String isLend;

    /** 归还日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "归还日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date returnTime;

    /** 归还时设备情况 */
    @Excel(name = "归还时设备情况")
    private String returnEquipmentCondition;

    /** 接收人id */
    private Long receivedById;

    /** 接收人 */
    @Excel(name = "接收人")
    private String receivedBy;

    /** 预计使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预计使用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date yjuseTime;

    /** 实际使用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "实际使用时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date sjuseTime;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

}
