package yangtz.cs.liu.campus.vo.schoolDcwj;

import com.core.domain.OurBaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import com.ruoyi.common.annotation.Excel;
import yangtz.cs.liu.campus.domain.schoolDcwj.SchoolDcwjAn;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * 回答结果对象 school_dcwj_an
 *
 * @author wengxiulin
 * @date 2023-03-01
 */
@Data
public class SchoolDcwjAnVo extends OurBaseEntity
{
    private static final long serialVersionUID = 1L;

    //班级
    //@Excel(name = "班级",combo = {"一班","二班","三班","四班","五班","六班","七班","八班"},readConverterExp = "1=一班,2=二班,3=三班,4=四班,5=五班,6=六班,7=七班,8=八班")
    private String classAlias;

    //姓名
    @Excel(name = "学生姓名")
    private String studentName;

    //填写状态
    @Excel(name = "是否填写(0否 1是)")
    private String ryZdzt;

    //填写时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "初次填写时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date ryCtime;

    /**
     * 学生家长调查问卷回答的内容
     */
    private List<SchoolDcwjAn> list;

}
