package yangtz.cs.liu.campus.vo.recipeVo;

import com.core.domain.OurBaseEntity;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class recipeVo extends OurBaseEntity {
    /** 食谱日期 */
    @Excel(name = "食谱日期", width = 30)
    @NotNull(message = "食谱日期不能为空")
    private Date date;

    /** 早餐 */
    @Excel(name = "早餐")
    @NotBlank(message = "早餐不能为空")
    private String breakfast;

    /** 早点 */
    @Excel(name = "早点")
    private String dessertAfterBreakfast;

    /** 午餐 */
    @NotBlank(message = "午餐不能为空")
    @Excel(name = "午餐")
    private String lunch;

    /** 午点 */
    @Excel(name = "午点")
    private String dessertAfterLunch;

    /** 晚餐 */
    @NotBlank(message = "晚餐不能为空")
    @Excel(name = "晚餐")
    private String dinner;
}
