package yangtz.cs.liu.campus.vo.device;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;
import yangtz.cs.liu.activiti.domain.ProcessBaseEntity;

import java.util.Date;

@Data
public class RecordListVo  extends ProcessBaseEntity {

    /** id */
    private Long id;

    private Long deviceId;
    @Excel(name = "设备名称")
    private String deviceName;

    /** 报修类型 */
    @Excel(name = "报修类型", readConverterExp = "0=故障维修,1=设备更换")
    private String repairType;

    /** 提报人 */
    @Excel(name = "提报人")
    private String Informant;

    /** 维修人 */
    @Excel(name = "维修人")
    private String maintainer;

    /** 故障描述 */
    @Excel(name = "故障描述")
    private String faultDescription;

    /** 备注 */
    @Excel(name = "备注")
    private String remark;

    /** 提报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "提报时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date reportingTime;

    /** 维修完成时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "维修完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date maintenanceCompletionTime;

    /** 流程实例ID */
   // @Excel(name = "流程实例ID")
    private String instanceId;

    /** 创建人 */
    //@Excel(name = "创建人")
    private String createBy;

    /** 申请人 */
    //@Excel(name = "申请人")
    private String applyUser;

    /** 申请时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
   // @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date applyTime;

    /** 状态 */
    //@Excel(name = "状态")
    private String state;

    private String roleKey;
    private String roleName;

}
