package yangtz.cs.liu.campus.vo.device;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class DeviceByIdVo {

    /** id */
    private Long id;

    /** 场地id */
    @NotNull(message ="不为空")
    private Long areaId;

    /** areaName */
    private String areaName;

    /** 设备编码 */
    @Excel(name = "设备编码")
    private String deviceCode;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String deviceName;

    /** 设备类型 */
    @Excel(name = "设备类型", readConverterExp = "0=教学设备,1=安全设备")
    private Integer deviceType;

    /** 设备状态 */
    @Excel(name = "设备状态", readConverterExp = "0=在用,1=维修,2=报废")
    private String deviceState;

    /** 启用时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "启用时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startDate;

    /** 供应商 */
    @Excel(name = "供应商")
    private String supplier;

    /** 规格型号 */
    @Excel(name = "规格型号")
    private String model;

    /** 出场日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出场日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date factoryDate;

    /** 质保期 */
    @Excel(name = "质保期")
    private String qualityTime;

    /** delFlag */
    @Excel(name = "delFlag")
    private String delFlag;

}
