package yangtz.cs.liu.campus.vo.curricula;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ruoyi.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class CurriculaStudentCjVo {

    /** 主键id */
    private Long id;
    /** 学生主键id */
    private Long studentId;
    /** 选课主键id */
    private Long curriculaId;
    /** 班级主键id */
    private Long classId;
    /** 班级 */
    @Excel(name = "班级")
    private String className;
    /** 学生姓名 */
    @Excel(name = "学生姓名")
    private String studentName;
    /** 学号 */
    @Excel(name = "学号")
    private String studentNumber;
    /** 身份证号 */
    @Excel(name = "身份证号")
    private String idCard;
    /** 成绩 */
    private double achievement;
    /** 课程类型（1-春季选课，2-夏季选课，3-艺体） */
    @Excel(name = "课程类型",readConverterExp = "1=春季选课,2=夏季选课,3=艺体")
    private String courseType;
    /** 选课时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "选课时间",dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date curriculaTime;
    /** 选课状态（1-未选课，2-已选课） */
//    @Excel(name = "选课状态",readConverterExp = "1=未选课,2=已选课")
    private String curriculaState;
    /** 已选课程成绩 */
    private double courseScore;
    /** 已选课程 */
    private String selectedCourse;
    /** 已选专业 */
    private String selectedMajor;
    /** 已选专业名称 */
    @Excel(name = "已选专业")
    private String selectedMajorName;
    /** 所选科目 */
//    @Excel(name = "所选科目",readConverterExp = "1=音乐,2=美术,3=田径,4=舞蹈")
    private String selectedSubject;
    /** 所分班级 */
//    @Excel(name = "所分班级")
    private String divisionClassesName;
    /** 是否删除 */
    private String delFalg;
}
