package yangtz.cs.liu.campus.vo.area;

import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.entity.SysMenu;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class AreaVO {
    private Long id;

    /** 场地号 */
    @Excel(name = "场地号")
    private String areaNum;

    /** 场地名称 */
    @Excel(name = "场地名称")
    private String areaName;

    /** 父节点 */
    @Excel(name = "父节点")
    private Long pid;

    /** 祖级列表 */
    @Excel(name = "祖级列表")
    private String ancestors;

    /** 场地类型 */
    @Excel(name = "场地类型")
    private String areaType;

    /** 场地简介 */
    @Excel(name = "场地简介")
    private String areaIntroduce;

    /** 是否开放(0开放场所 1需要预约 2不开放) */
    @Excel(name = "是否开放(0开放场所 1需要预约 2不开放)")
    private String areaOpen;

    /** 子菜单 */
    private List<AreaVO> children = new ArrayList<AreaVO>();

    /** 父场地名称 */
    private String parentName;

}
