package yangtz.cs.liu.campus.service.vehicle;

import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.office.SchoolOfficePurchase;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicleApplication;
import yangtz.cs.liu.campus.vo.office.OfficeTodoListVO;
import yangtz.cs.liu.campus.vo.vehicle.VehicleApplicationVO;

/**
 * 用车申请Service接口
 *
 * @author xu
 * @date 2022-09-29
 */
public interface ISchoolVehicleApplicationService extends IService<SchoolVehicleApplication> {

    /**
     * 查询用车申请列表
     *
     * @param vehicleApplicationVO 用车申请
     * @return 用车申请集合
     */
    public List<VehicleApplicationVO> queryList(VehicleApplicationVO vehicleApplicationVO);

    public List<VehicleApplicationVO> getByIds(List<Long> ids);

    //获取车辆申请详情
    public VehicleApplicationVO getInfo(Long id);

    /**
     * 流程定义
     *
     * @param schoolVehicleApplication
     * @param username
     * @param key

     */
    int submitApply(SchoolVehicleApplication schoolVehicleApplication, String username, String key);

    /**
     * 待办列表
     *
     * @param entity
     * @param userId
     * @return
     */

}
