package yangtz.cs.liu.campus.service.teacherFiles;

import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFiles;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNotice;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesVO;

import java.util.List;

/**
 * 教师档案Service接口
 * 
 * @author ruoyi
 * @date 2023-09-06
 */
public interface ITeacherFilesService 
{
    /**
     * 查询教师档案
     * 
     * @param id 教师档案主键
     * @return 教师档案
     */
    public TeacherFilesVO selectTeacherFilesById(Long id);

    /**
     * 查询教师档案列表
     * 
     * @param teacherFiles 教师档案
     * @return 教师档案集合
     */
    public List<TeacherFiles> selectTeacherFilesList(TeacherFiles teacherFiles);
    public List<TeacherFilesNotice> selctTeacherByUserId(Long userId);

    /**
     * 新增教师档案
     * 
     * @param teacherFiles 教师档案
     * @return 结果
     */
    public int insertTeacherFiles(TeacherFiles teacherFiles);

    /**
     * 修改教师档案
     * 
     * @param teacherFiles 教师档案
     * @return 结果
     */
    public int updateTeacherFiles(TeacherFiles teacherFiles);

    /**
     * 批量删除教师档案
     * 
     * @param ids 需要删除的教师档案主键集合
     * @return 结果
     */
    public int deleteTeacherFilesByIds(Long[] ids);

    /**
     * 删除教师档案信息
     * 
     * @param id 教师档案主键
     * @return 结果
     */
    public int deleteTeacherFilesById(Long id);


    public int synchronous(Long id);
}
