package yangtz.cs.liu.campus.service.teacherFiles;

import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNotice;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNoticeTotal;

import java.util.List;

/**
 * 教师档案通知Service接口
 * 
 * @author ruoyi
 * @date 2023-09-06
 */
public interface ITeacherFilesNoticeService 
{
    /**
     * 查询教室档案通知
     * 
     * @param id 教师档案通知主键
     * @return 教师档案通知
     */
    public TeacherFilesNotice selectTeacherFilesNoticeById(String id);

    /**
     * 查询教室档案通知列表
     * 
     * @param teacherFilesNotice 教师档案通知
     * @return 教室档案通知集合
     */
    public List<TeacherFilesNoticeTotal> selectTeacherFilesNoticeList(TeacherFilesNotice teacherFilesNotice);

    /**
     * 新增教室档案通知
     * 
     * @param teacherFilesNotice 教师档案通知
     * @return 结果
     */
    public int insertTeacherFilesNotice(TeacherFilesNotice teacherFilesNotice);

    /**
     * 修改教室档案通知
     * 
     * @param teacherFilesNotice 教师档案通知
     * @return 结果
     */
    public int updateTeacherFilesNotice(TeacherFilesNotice teacherFilesNotice);

    public int release(String id);

    public int withdraw(String id);

    public int complete(String id);

    /**
     * 批量删除教师档案通知
     * 
     * @param ids 需要删除的教室档案通知主键集合
     * @return 结果
     */
    public int deleteTeacherFilesNoticeByIds(String[] ids);

    /**
     * 删除教室教师通知信息
     * 
     * @param id 教室档案通知主键
     * @return 结果
     */
    public int deleteTeacherFilesNoticeById(String id);
}
