package yangtz.cs.liu.campus.service.studentTurnover;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.studentTurnover.StudentTurnover;
import yangtz.cs.liu.campus.vo.studentTurnover.TurnoverVo;

import java.util.List;

/**
 * 异动管理Service接口
 *
 * @author wengxiulin
 * @date 2023-02-20
 */
public interface IStudentTurnoverService extends IService<StudentTurnover>
{
    /**
     * 查询异动管理
     *
     * @param id 异动管理主键
     * @return 异动管理
     */
    public StudentTurnover selectStudentTurnoverById(Long id);

    /**
     * 查询异动管理列表
     *
     * @param studentTurnover 异动管理
     * @return 异动管理集合
     */
    public List<StudentTurnover> selectStudentTurnoverList(StudentTurnover studentTurnover);

    //获取详情
    TurnoverVo queryInfo(Long id);

    /**
     * 新增异动管理
     *
     * @param studentTurnover 异动管理
     * @return 结果
     */
    public int insertStudentTurnover(StudentTurnover studentTurnover);

    /**
     * 修改异动管理
     *
     * @param studentTurnover 异动管理
     * @return 结果
     */
    public int updateStudentTurnover(StudentTurnover studentTurnover);

    /**
     * 批量删除异动管理
     *
     * @param ids 需要删除的异动管理主键集合
     * @return 结果
     */
    public int deleteStudentTurnoverByIds(Long[] ids);

    /**
     * 删除异动管理信息
     *
     * @param id 异动管理主键
     * @return 结果
     */
    public int deleteStudentTurnoverById(Long id);
}
