package yangtz.cs.liu.campus.service.student;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEducational;

import java.util.List;

/**
 * 学生Service接口
 *
 * @author hxz
 * @date 2023-02-26
 */
public interface ISchoolStudentEducationalService extends IService<SchoolStudentEducational>
{
    /**
     * 查询学生
     *
     * @param id 学生主键
     * @return 学生
     */
    public SchoolStudentEducational selectSchoolStudentEducationalById(Long id);

    /**
     * 查询学生列表
     *
     * @param schoolStudentEducational 学生
     * @return 学生集合
     */
    public List<SchoolStudentEducational> selectSchoolStudentEducationalList(SchoolStudentEducational schoolStudentEducational);

    /**
     * 新增学生
     *
     * @param schoolStudentEducational 学生
     * @return 结果
     */
    public int insertSchoolStudentEducational(SchoolStudentEducational schoolStudentEducational);

    /**
     * 修改学生
     *
     * @param schoolStudentEducational 学生
     * @return 结果
     */
    public int updateSchoolStudentEducational(SchoolStudentEducational schoolStudentEducational);

    /**
     * 批量删除学生
     *
     * @param ids 需要删除的学生主键集合
     * @return 结果
     */
    public int deleteSchoolStudentEducationalByIds(Long[] ids);

    /**
     * 删除学生信息
     *
     * @param id 学生主键
     * @return 结果
     */
    public int deleteSchoolStudentEducationalById(Long id);
}
