package yangtz.cs.liu.campus.service.schooloffical;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schooloffical.SchoolOfficialFlow;
import yangtz.cs.liu.campus.vo.schoolOfficial.SchoolOfficialFlowVo;

import java.util.List;

public interface ISchoolOfficialFlowService extends IService<SchoolOfficialFlow> {
    public boolean flow(SchoolOfficialFlow schoolOfficialFlow);

    public int updateSchoolOfficialFlow(SchoolOfficialFlow schoolOfficialFlow);

    //根据主表id选择状态为已完成的子表信息
    List<SchoolOfficialFlowVo> getReviewList(Long id);

    //批阅人操作
    int review(SchoolOfficialFlow flow);

    //根据未发文主表id，查询其批阅人
    SchoolOfficialFlow getReviewByOfficialId(Long officialId,String receiveType);

    //发起人操作
    int chooseReview(Long id, Long userId,Long[] userIds);

    //根据主表id，用户id，接收人类型，查询状态，并修改
    int editState(Long id, Long userId, String receiveType);
}
