package yangtz.cs.liu.campus.service.schoolStudio;

import yangtz.cs.liu.campus.domain.schoolStudio.SchoolStudioAppointment;

import java.util.List;

/**
 * 录播室预约情况Service接口
 *
 * @author ruoyi
 * @date 2023-07-10
 */
public interface ISchoolStudioAppointmentService
{
    /**
     * 查询全部录播室预约情况
     *
     * @param id 录播室预约情况主键
     * @return 录播室预约情况
     */
    public SchoolStudioAppointment selectSchoolStudioAppointmentById(Long id);

    /**
     * 查询录播室预约情况列表
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 录播室预约情况集合
     */
    public List<SchoolStudioAppointment> selectSchoolStudioAppointmentList(SchoolStudioAppointment schoolStudioAppointment);

    /**
     * 新增录播室预约
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 结果
     */
    public int insertSchoolStudioAppointment(SchoolStudioAppointment schoolStudioAppointment);

    /**
     * 取消录播室预约
     *
     * @param schoolStudioAppointment 录播室预约情况
     * @return 结果
     */
    public int updateSchoolStudioAppointment(SchoolStudioAppointment schoolStudioAppointment);

    /**
     * 查询个人录播室预约情况列表
     * @param schoolStudioAppointment
     * @return
     */
    List<SchoolStudioAppointment> selectSchoolStudioAppointmentListGr(SchoolStudioAppointment schoolStudioAppointment);

//    /**
//     * 批量删除录播室预约情况
//     *
//     * @param ids 需要删除的录播室预约情况主键集合
//     * @return 结果
//     */
//    public int deleteSchoolStudioAppointmentByIds(Long[] ids);
//
//    /**
//     * 删除录播室预约情况信息
//     *
//     * @param id 录播室预约情况主键
//     * @return 结果
//     */
//    public int deleteSchoolStudioAppointmentById(Long id);
}
