package yangtz.cs.liu.campus.service.schoolLab;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ruoyi.common.core.domain.entity.SysUser;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolTeacherLabApply;
import yangtz.cs.liu.campus.vo.schoolLab.ClassSituationVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolTeacherLabApplyVo;

import java.util.List;
import java.util.Map;

/**
 * 教师实验室申请Service接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface ISchoolTeacherLabApplyService extends IService<SchoolTeacherLabApply>
{
    /**
     * 查询教师实验室申请
     *
     * @param id 教师实验室申请主键
     * @return 教师实验室申请
     */
    public SchoolTeacherLabApplyVo selectSchoolTeacherLabApplyById(Long id);

    /**
     * 查询教师实验室申请列表
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 教师实验室申请集合
     */
    public List<SchoolTeacherLabApplyVo> selectSchoolTeacherLabApplyList(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 新增教师实验室申请
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 结果
     */
    public int insertSchoolTeacherLabApply(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 修改教师实验室申请
     *
     * @param schoolTeacherLabApplyVo 教师实验室申请
     * @return 结果
     */
    public int updateSchoolTeacherLabApply(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 批量删除教师实验室申请
     *
     * @param ids 需要删除的教师实验室申请主键集合
     * @return 结果
     */
    public int deleteSchoolTeacherLabApplyByIds(Long[] ids);

    /**
     * 删除教师实验室申请信息
     *
     * @param id 教师实验室申请主键
     * @return 结果
     */
    public int deleteSchoolTeacherLabApplyById(Long id);

    /**
     * 获取实验室使用状态
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String, Object>> getTeacherLab(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 获取班级
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String, Object>> getTeacherClass(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo,
        SysUser sysUser);

    /**
     * 上传附件
     * @param schoolTeacherLabApplyVo
     * @return
     */
    int updateTeacherLab(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 实验室管理-教师申请列表
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<SchoolTeacherLabApplyVo> getTeacherLabApplyList(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 实验室管理-教师申请审批确认
     * @param schoolTeacherLabApply
     * @return
     */
    int updateState(SchoolTeacherLabApply schoolTeacherLabApply);

    /**
     * 查看班级完成详情
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String,Object>> getClassDetails(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 教师实验统计
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String,Object>> getCountTeacher(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 级部-班级完成情况明细
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<Map<String,Object>> gradeCountClass(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * 级部-班级完成情况明细-查看班级完成情况详情
     * @param schoolTeacherLabApplyVo
     * @return
     */
    List<SchoolTeacherLabApplyVo> getGradeClassDetails(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * xwh-新增教师申请
     * @param schoolTeacherLabApplyVo
     * @return
     */
    int insertSchoolTeacherLabApplyVo(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    /**
     * xwh-修改教师申请
     * @param schoolTeacherLabApplyVo
     * @return
     */
    int updateSchoolTeacherLabApplyVo(SchoolTeacherLabApplyVo schoolTeacherLabApplyVo);

    List<SchoolTeacherLabApplyVo> getTeacherExperimentList(ClassSituationVo one);
    List<Map<String,String>> selectTeacherList(SchoolTeacherLabApply schoolTeacherLabApply);
}
