package yangtz.cs.liu.campus.service.schoolLab;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolLab.SchoolLabClassYear;
import yangtz.cs.liu.campus.vo.schoolLab.ClassSituationVo;
import yangtz.cs.liu.campus.vo.schoolLab.SchoolLabClassYearVo;

import java.util.List;
import java.util.Map;

/**
 * 年级实验室预约Service接口
 *
 * @author ruoyi
 * @date 2023-08-29
 */
public interface ISchoolLabClassYearService extends IService<SchoolLabClassYear>
{

    /**
     * 查询年级实验室预约
     *
     * @param id 年级实验室预约主键
     * @return 年级实验室预约
     */
    public SchoolLabClassYearVo selectSchoolLabClassYearById(Long id);

    /**
     * 查询年级实验室预约列表
     *
     * @param schoolLabClassYearVo 年级实验室预约
     * @return 年级实验室预约集合
     */
    public List<SchoolLabClassYearVo> selectSchoolLabClassYearList(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * 新增年级实验室预约
     *
     * @param schoolLabClassYear 年级实验室预约
     * @return 结果
     */
    public int insertSchoolLabClassYear(SchoolLabClassYear schoolLabClassYear);
    public List<String> getYearList();
    public String getSub();

    /**
     * 修改年级实验室预约
     *
     * @param schoolLabClassYear 年级实验室预约
     * @return 结果
     */
    public int updateSchoolLabClassYear(SchoolLabClassYear schoolLabClassYear);

    /**
     * 批量删除年级实验室预约
     *
     * @param ids 需要删除的年级实验室预约主键集合
     * @return 结果
     */
    public int deleteSchoolLabClassYearByIds(Long[] ids);

    /**
     * 删除年级实验室预约信息
     *
     * @param id 年级实验室预约主键
     * @return 结果
     */
    public int deleteSchoolLabClassYearById(Long id);

    /**
     * 实验室管理-年级实验室预约列表
     * @param schoolLabClassYearVo
     * @return
     */
    List<SchoolLabClassYearVo> getLabClassYear(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * 实验室管理-年级实验室-分配实验室
     * @param schoolLabClassYearVo
     * @return
     */
    int updateLabClassYear(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * 获取实验室
     * @param schoolLabClassYearVo
     * @return
     */
    List<Map<String,Object>> getLabList(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * 实验室管理-年级实验室预约查看详情
     * @param id
     * @return
     */
    SchoolLabClassYearVo getLabClassYearById(Long id);

    /**
     * 教师-实验室安排列表
     * @param schoolLabClassYearVo
     * @return
     */
    List<SchoolLabClassYearVo> getTeacherLabList(SchoolLabClassYearVo schoolLabClassYearVo);

    /**
     * xwh-新增年级预约
     * @param schoolLabClassYear
     * @return
     */
    int insertSchoolLabClassYearVo(SchoolLabClassYear schoolLabClassYear);

    /**
     * xwh-修改年级预约
     * @param schoolLabClassYear
     * @return
     */
    int updateSchoolLabClassYearVo(SchoolLabClassYear schoolLabClassYear);

    public List<ClassSituationVo>  classSituation(ClassSituationVo classSituationVo);
    public List<ClassSituationVo>  getexperimentList(ClassSituationVo classSituationVo);
}
