package yangtz.cs.liu.campus.service.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolProductCategory;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolProductCategoryVo;

import java.util.List;
import java.util.Map;

public interface IProductCategoryService extends IService<SchoolProductCategory> {

    /**
     * 查询产品分类列表
     * @param schoolProductCategory
     * @return
     */
    List<SchoolProductCategory> selectSchoolProductCateGory(SchoolProductCategory schoolProductCategory);

    /**
     * 查看产品分类详细信息
     * @param id
     * @return
     */
    SchoolProductCategoryVo selectSchoolProductCateGoryById(Long id);

    /**
     * 新增产品分类
     * @param schoolProductCategory
     * @return
     */
    int insertSchoolProductCategory(SchoolProductCategory schoolProductCategory);

    /**
     * 修改产品分类信息
     * @param schoolProductCategory
     * @return
     */
    int updateSchoolProductCategory(SchoolProductCategory schoolProductCategory);

    /**
     * 删除产品分类信息
     * @param ids
     * @return
     */
    int deleteSchoolProductCategory(Long[] ids);

    /**
     * 获取设备分类下拉框
     * @param
     * @return
     */
    List<Map<String,String>> getEquipmentType(SchoolProductCategory schoolProductCategory);

    /**
     * 获取管理员
     * @return
     */
    List<Map<String,String>> getAdmin(SchoolProductCategory schoolProductCategory);

    /**
     * 根据分类编码查询产品分类信息
     * @param code
     * @return
     */
    SchoolProductCategory getEquipmentByCode(String code);
}
