package yangtz.cs.liu.campus.service.schoolEquipment;

import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolCirculation;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolCirculationVo;

import java.util.List;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolReceiveQuery;

public interface ICirculationService extends IService<SchoolCirculation> {

  List<SchoolCirculationVo> getReturningEquipmentByadminId(SchoolReceiveQuery schoolReceiveQuery);

  SchoolCirculationVo getSchoolCirculationVoById(Long id);

  SchoolCirculationVo getSchoolCirculationVoByenCode(String enCode);
    /**
     * 查看设备借出归还列表
     * @param schoolCirculationVo
     * @return
     */
    List<SchoolCirculationVo> selectSchoolCirculationVoList(SchoolCirculationVo schoolCirculationVo);
    List<SchoolCirculationVo> selectVxSchoolCirculationVoList(SchoolReceiveQuery schoolCirculationVo);

    /**
     * 查看设备借出归还详细信息
     * @param id
     * @return
     */
    SchoolCirculationVo selectSchoolCirculationVoById(Long id);

    /**
     * 新增设备借出归还信息
     * @param schoolCirculation
     * @return
     */
    int insertSchoolCirculation(SchoolCirculation schoolCirculation);

    /**
     * 修改设备借出归还信息
     * @param schoolCirculation
     * @return
     */
    int updateSchoolCirculation(SchoolCirculation schoolCirculation);

    /**
     * 删除设备借出归还信息
     * @param ids
     * @return
     */
    int deleteSchoolCirculationByIds(Long[] ids);

}
