package yangtz.cs.liu.campus.service.schoolDuty;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.schoolDuty.SchoolDutyDetails;
import yangtz.cs.liu.campus.vo.schoolDuty.DutyHoildayVo;
import yangtz.cs.liu.campus.vo.schoolDuty.DutyVacationVo;

/**
 * 值班管理明细Service接口
 */
public interface ISchoolDutyDetailsService extends IService<SchoolDutyDetails> {

    /**
     * 查询值班管理明细列表
     *
     * @param schoolDutyDetails 值班管理明细
     * @return 值班管理明细集合
     */
    public List<SchoolDutyDetails> selectSchoolDutyDetailsList(SchoolDutyDetails schoolDutyDetails);

    /**
     * 检查导入时的数据
     */
    void checkData(List<SchoolDutyDetails> list, Long dutyId);


    /**
     * 数据导入
     */
    String importDutyDetails(List<SchoolDutyDetails> list, Long dutyId);

    /**
     * 制作下载模板的一个集合寒暑假
     */
    List<SchoolDutyDetails> getDuty(Date startDate, Date endDate) throws ParseException;

    /**
     * 制作下载模板的一个集合节日
     */
    List<SchoolDutyDetails> getHoildayDuty(Date startDate, Date endDate) throws ParseException;

    //节日值班表查看
    DutyHoildayVo selectHoliday(Long id);

    //寒暑假值班表查看
    DutyVacationVo selectVacation(Long id);
}
