package yangtz.cs.liu.campus.service.patrol;

import com.baomidou.mybatisplus.extension.service.IService;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrol;
import yangtz.cs.liu.campus.domain.patrol.SchoolPatrolDetails;
import yangtz.cs.liu.campus.vo.patrol.SchoolPatrolVo;
import yangtz.cs.liu.wechat.vo.patrol.PatrolVo;

import java.util.List;

/**
 * 课堂巡视Service接口
 */
public interface ISchoolPatrolService extends IService<SchoolPatrol> {

    /**
     * 查询巡视列表
     *
     * @param schoolPatrol
     * @return
     */
    List<SchoolPatrolVo> queryList(SchoolPatrolVo schoolPatrol);


    /**
     * 重新打分
     *
     * @param patrolId
     * @return
     */
    int rescore(Long patrolId);


    List<SchoolPatrolVo> exportByIds(List<Integer> ids);

    List<PatrolVo> getPatrolList(Long teacherId, Long classId);
}
