package yangtz.cs.liu.campus.service.material;

import java.util.List;
import yangtz.cs.liu.campus.domain.material.Material;

/**
 * 课题、结题、专著、校本教材编写情况Service接口
 *
 * @author ruoyi
 * @date 2023-07-25
 */
public interface IMaterialService
{
    /**
     * 查询课题、结题、专著、校本教材编写情况
     *
     * @param id 课题、结题、专著、校本教材编写情况主键
     * @return 课题、结题、专著、校本教材编写情况
     */
    public Material selectMaterialById(Long id);

    /**
     * 查询课题、结题、专著、校本教材编写情况列表
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 课题、结题、专著、校本教材编写情况集合
     */
    public List<Material> selectMaterialList(Material material);

    /**
     * 新增课题、结题、专著、校本教材编写情况
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 结果
     */
    public int insertMaterial(Material material);

    /**
     * 修改课题、结题、专著、校本教材编写情况
     *
     * @param material 课题、结题、专著、校本教材编写情况
     * @return 结果
     */
    public int updateMaterial(Material material);

    /**
     * 批量删除课题、结题、专著、校本教材编写情况
     *
     * @param ids 需要删除的课题、结题、专著、校本教材编写情况主键集合
     * @return 结果
     */
    public int deleteMaterialByIds(Long[] ids);

    /**
     * 删除课题、结题、专著、校本教材编写情况信息
     *
     * @param id 课题、结题、专著、校本教材编写情况主键
     * @return 结果
     */
    public int deleteMaterialById(Long id);
}
