package yangtz.cs.liu.campus.service.impl.workDay;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.core.utils.HolidayDateUtil;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.workDay.SchoolWorkDay;
import yangtz.cs.liu.campus.mapper.workDay.SchoolWorkDayMapper;
import yangtz.cs.liu.campus.service.workDay.ISchoolWorkDayService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

@Service
public class SchoolWorkDayServiceImpl extends ServiceImpl<SchoolWorkDayMapper, SchoolWorkDay> implements ISchoolWorkDayService {

    @Autowired
    private SchoolWorkDayMapper dayMapper;

    @Override
    public List<String> getHolidayList(Date startTime, Date endTime, String type) {
        LambdaQueryWrapper<SchoolWorkDay> lqw = new LambdaQueryWrapper<>();
        lqw
                .ge(SchoolWorkDay::getRepDate,startTime)
                .le(SchoolWorkDay::getRepDate,endTime)
                .eq(isNotBlank(type),SchoolWorkDay::getDateType,type)
                ;
        List<SchoolWorkDay> days = dayMapper.selectList(lqw);
        if (StringUtils.isNull(days)){
            return new ArrayList<>();
        }
        List<String> list = new ArrayList<>();
        for(SchoolWorkDay day : days){
            String time =  HolidayDateUtil.format1.format( day.getRepDate());
            list.add(time);
        }
        return list;
    }
    public List<String> getHolidayList(String type) {
        LambdaQueryWrapper<SchoolWorkDay> lqw = new LambdaQueryWrapper<>();
        lqw
            .eq(isNotBlank(type),SchoolWorkDay::getDateType,type)
        ;
        List<SchoolWorkDay> days = dayMapper.selectList(lqw);
        if (StringUtils.isNull(days)){
            return new ArrayList<>();
        }
        List<String> list = new ArrayList<>();
        for(SchoolWorkDay day : days){
            String time =  HolidayDateUtil.format1.format( day.getRepDate());
            list.add(time);
        }
        return list;
    }
}
