package yangtz.cs.liu.campus.service.impl.time;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.time.SchoolTimeDetail;
import yangtz.cs.liu.campus.mapper.time.SchoolTimeDetailMapper;
import yangtz.cs.liu.campus.service.time.ISchoolTimeDetailService;
import yangtz.cs.liu.campus.vo.time.SchoolTimeDetailVO;

import java.util.List;

@Service
public class SchoolTimeDetailServiceImpl extends ServiceImpl<SchoolTimeDetailMapper, SchoolTimeDetail> implements ISchoolTimeDetailService {

    @Autowired
    private SchoolTimeDetailMapper schoolTimeDetailMapper;

    @Override
    public List<SchoolTimeDetailVO> selectSchoolTimeDetailList(SchoolTimeDetail schoolTimeDetail)
    {
        return schoolTimeDetailMapper.selectSchoolTimeDetailList(schoolTimeDetail);
    }

    @Override
    public Integer selectTotalCount(Long schoolTimeId) {
        Integer totalCount = schoolTimeDetailMapper.selectTotalCount(schoolTimeId);
        if(StringUtils.isNull(totalCount)){
            throw new ServiceException("一天课时数不能为空");
        }
        return totalCount;
    }

    @Override
    public Integer selectAmCount(Long schoolTimeId) {
        String name = "午间休息";
        Integer amCount = schoolTimeDetailMapper.selectAmCount(schoolTimeId,name);
        if(StringUtils.isNull(amCount)){
            throw new ServiceException("上午课时数不能为空");
        }
        return amCount;
    }
    @Override
    public Integer selectPmCount(Long schoolTimeId) {
        String name = "晚间休息";
        Integer pmCount = schoolTimeDetailMapper.selectPmCount(schoolTimeId,name);
        if(StringUtils.isNull(pmCount)){
            throw new ServiceException("下午课时数不能为空");
        }
        return pmCount;
    }
}
