package yangtz.cs.liu.campus.service.impl.thesis;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import yangtz.cs.liu.campus.domain.accessory.SchoolAccessory;
import yangtz.cs.liu.campus.mapper.accessory.AccessoryMapper;
import yangtz.cs.liu.campus.mapper.thesis.ThesisMapper;
import yangtz.cs.liu.campus.domain.thesis.Thesis;
import yangtz.cs.liu.campus.service.thesis.IThesisService;

/**
 * 论文情况Service业务层处理
 *
 * @author ruoyi
 * @date 2023-07-24
 */
@Service
public class ThesisServiceImpl implements IThesisService
{
    @Autowired
    private ThesisMapper thesisMapper;
    @Autowired
    private AccessoryMapper accessoryMapper;

    /**
     * 查询论文情况
     *
     * @param id 论文情况主键
     * @return 论文情况
     */
    @Override
    public Thesis selectThesisById(Long id)
    {
        Thesis thesis = thesisMapper.selectThesisById(id);
        LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SchoolAccessory::getBusinessId,thesis.getId())
                .eq(SchoolAccessory::getAccessoryType,"论文情况附件");
        List<SchoolAccessory> accessories = accessoryMapper.selectList(wrapper);
        if (StringUtils.isNotNull(accessories) && accessories.size() > 0){
            thesis.setSchoolAccessoryList(accessories);
        }
        return thesis;
    }

    /**
     * 查询论文情况列表
     *
     * @param thesis 论文情况
     * @return 论文情况
     */
    @Override
    public List<Thesis> selectThesisList(Thesis thesis)
    {
        thesis.setTeacherId(SecurityUtils.getLoginUser().getUser().getUserId());
        List<Thesis> list = thesisMapper.selectThesisList(thesis);
        list.forEach(thesis1 -> {
            LambdaQueryWrapper<SchoolAccessory> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(SchoolAccessory::getBusinessId,thesis1.getId())
                   .eq(SchoolAccessory::getAccessoryType,"论文情况附件");
            List<SchoolAccessory> accessories = accessoryMapper.selectList(wrapper);
            if (StringUtils.isNotNull(accessories) && accessories.size() > 0){
                thesis1.setSchoolAccessoryList(accessories);
            }
        });
        return list;
    }

    /**
     * 新增论文情况
     *
     * @param thesis 论文情况
     * @return 结果
     */
    @Transactional
    @Override
    public int insertThesis(Thesis thesis)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        thesis.setTeacherId(user.getUserId());
        thesis.setTeacherName(user.getUserName());
        thesis.setCreateBy(user.getUserName());
        thesis.setCreateTime(DateUtils.getNowDate());
        int rows = thesisMapper.insertThesis(thesis);
        insertAccessory(thesis);
        return rows;
    }

    /**
     * 修改论文情况
     *
     * @param thesis 论文情况
     * @return 结果
     */
    @Transactional
    @Override
    public int updateThesis(Thesis thesis)
    {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        thesis.setUpdateBy(user.getUserName());
        thesis.setUpdateTime(DateUtils.getNowDate());
        thesisMapper.deleteSchoolAccessoryByBusinessId(thesis.getId());
        insertAccessory(thesis);
        return thesisMapper.updateThesis(thesis);
    }

    /**
     * 批量删除论文情况
     *
     * @param ids 需要删除的论文情况主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteThesisByIds(Long[] ids)
    {
        thesisMapper.deleteSchoolAccessoryByBusinessIds(ids);
        return thesisMapper.deleteThesisByIds(ids);
    }

    /**
     * 删除论文情况信息
     *
     * @param id 论文情况主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteThesisById(Long id)
    {
        thesisMapper.deleteSchoolAccessoryByBusinessId(id);
        return thesisMapper.deleteThesisById(id);
    }

    /**
     * 新增附件信息
     *
     * @param thesis 论文情况对象
     */
    public void insertAccessory(Thesis thesis)
    {
        List<SchoolAccessory> schoolAccessoryList = thesis.getSchoolAccessoryList();
        Long id = thesis.getId();
        if (StringUtils.isNotNull(schoolAccessoryList))
        {
            List<SchoolAccessory> list = new ArrayList<SchoolAccessory>();
            for (SchoolAccessory schoolAccessory : schoolAccessoryList)
            {
                schoolAccessory.setModuleName("个人工作-论文情况");
                schoolAccessory.setAccessoryType("论文情况附件");
                schoolAccessory.setBusinessId(id);
                list.add(schoolAccessory);
            }
            if (list.size() > 0)
            {
                thesisMapper.batchSchoolAccessory(list);
            }
        }
    }
}
