package yangtz.cs.liu.campus.service.impl.teacherFiles;

import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.TermRange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.award.Award;
import yangtz.cs.liu.campus.domain.material.Material;
import yangtz.cs.liu.campus.domain.teacherFiles.*;
import yangtz.cs.liu.campus.domain.thesis.Thesis;
import yangtz.cs.liu.campus.domain.training.Training;
import yangtz.cs.liu.campus.mapper.teacherFiles.*;
import yangtz.cs.liu.campus.service.teacherFiles.ITeacherFilesService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 教师档案Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-09-06
 */
@Service
public class TeacherFilesServiceImpl implements ITeacherFilesService
{
    @Autowired
    private TeacherFilesMapper teacherFilesMapper;

    @Autowired
    private TeacherFilesMaterialMapper FmaterialMapper;

    @Autowired
    private TeacherFilesThesisMapper FthesisMapper;

    @Autowired
    private TeacherFilesAwardMapper FawardMapper;

    @Autowired
    private TeacherFilesTrainingMapper FtrainingMapper;

    @Autowired
    private TeacherFilesNoticeMapper teacherFilesNoticeMapper;


    /**
     * 查询教师档案
     * 
     * @param id 教师档案主键
     * @return 教师档案
     */
    @Override
    public TeacherFilesVO selectTeacherFilesById(Long id)
    {
        TeacherFilesVO teacherFiles = teacherFilesMapper.selectTeacherFilesById(id);
        teacherFiles.setMaterialList(FmaterialMapper.selectTeacherFilesMaterialListByFilesId(id));
        teacherFiles.setThesisList(FthesisMapper.selectTeacherFilesThesisListByFilesId(id));
        teacherFiles.setTrainingList(FtrainingMapper.selectTeacherFilesTrainingListByFilesId(id));
        teacherFiles.setAwardList(FawardMapper.selectTeacherFilesAwardListByFilesId(id));
        return teacherFiles;
    }

    /**
     * 查询教师档案列表
     * 
     * @param teacherFiles 教师档案
     * @return 教师档案
     */
    @Override
    public List<TeacherFiles> selectTeacherFilesList(TeacherFiles teacherFiles)
    {
        return teacherFilesMapper.selectTeacherFilesList(teacherFiles);
    }


    @Override
    public List<TeacherFilesNotice> selctTeacherByUserId(Long userId) {
        return teacherFilesNoticeMapper.selctTeacherByUserId(userId);
    }

    /**
     * 新增教师档案
     * 
     * @param teacherFiles 教师档案
     * @return 结果
     */
    @Override
    public int insertTeacherFiles(TeacherFiles teacherFiles)
    {
        return teacherFilesMapper.insertTeacherFiles(teacherFiles);
    }

    /**
     * 修改教师档案
     * 
     * @param teacherFiles 教师档案
     * @return 结果
     */
    @Override
    public int updateTeacherFiles(TeacherFiles teacherFiles)
    {
        return teacherFilesMapper.updateTeacherFiles(teacherFiles);
    }

    /**
     * 批量删除教师档案
     * 
     * @param ids 需要删除的教师档案主键
     * @return 结果
     */
    @Override
    public int deleteTeacherFilesByIds(Long[] ids)
    {
        return teacherFilesMapper.deleteTeacherFilesByIds(ids);
    }

    /**
     * 删除教师档案信息
     * 
     * @param id 教师档案主键
     * @return 结果
     */
    @Override
    public int deleteTeacherFilesById(Long id)
    {
        return teacherFilesMapper.deleteTeacherFilesById(id);
    }

    @Override
    public int synchronous(Long id) {
        TeacherFilesVO teacherFiles = teacherFilesMapper.selectTeacherFilesById(id);
        TeacherFilesNotice teacherFilesNotice = teacherFilesNoticeMapper.selectTeacherFilesNoticeById(teacherFiles.getNoticeId());
        Map map = new HashMap<>();
        map.put("teacherId",teacherFiles.getTeacherId());
        TermRange termRange = DateUtils.getTermRange(teacherFilesNotice.getNoticeYear(), teacherFilesNotice.getNoticeSemester());
        map.put("startDay",termRange.getStartDay());
        map.put("endDay",termRange.getEndDay());
        FthesisMapper.deleteTeacherFilesThesisByFilesId(id);
        for (Thesis thesis:FthesisMapper.selectThesisList(map)){
            TeacherFilesThesis teacherFilesThesis = new TeacherFilesThesis();
            teacherFilesThesis.setFilesId(id);
            teacherFilesThesis.settId(thesis.getId());
            teacherFilesThesis.setThesisName(thesis.getThesisName());
            teacherFilesThesis.setLevel(thesis.getLevel());
            teacherFilesThesis.setGrade(thesis.getGrade());
            teacherFilesThesis.setPublishTime(thesis.getPublishTime());
            FthesisMapper.insertTeacherFilesThesis(teacherFilesThesis);
        }
        FmaterialMapper.deleteTeacherFilesMaterialByFilesId(id);
        for (Material material:FmaterialMapper.selectMaterialList(map)){
            TeacherFilesMaterial teacherFilesMaterial = new TeacherFilesMaterial();
            teacherFilesMaterial.setFilesId(id);
            teacherFilesMaterial.settId(material.getId());
            teacherFilesMaterial.setName(material.getName());
            teacherFilesMaterial.setPublishTime(material.getPublishTime());
            FmaterialMapper.insertTeacherFilesMaterial(teacherFilesMaterial);
        }
        FawardMapper.deleteTeacherFilesAwardByFilesId(id);
        for(Award award : FawardMapper.selectAwardList(map)){
            TeacherFilesAward teacherFilesAward =new TeacherFilesAward();
            teacherFilesAward.setFilesId(id);
            teacherFilesAward.settId(award.getId());
            teacherFilesAward.setAwardName(award.getAwardName());
            teacherFilesAward.setAwardTime(award.getAwardTime());
            teacherFilesAward.setGradeOfAward(award.getGradeOfAward());
            teacherFilesAward.setLicenseIssuingAuthority(award.getLicenseIssuingAuthority());
            FawardMapper.insertTeacherFilesAward(teacherFilesAward);
        }
        FtrainingMapper.deleteTeacherFilesTrainingByFilesId(id);
        for (Training training : FtrainingMapper.selectTrainingList(map)){
            TeacherFilesTraining teacherFilesTraining = new TeacherFilesTraining();
            teacherFilesTraining.setFilesId(id);
            teacherFilesTraining.settId(training.getId());
            teacherFilesTraining.setTrainingName(training.getTrainingName());
            teacherFilesTraining.setTrainingTime(training.getTrainingTime());
            teacherFilesTraining.setIsQualified(training.getIsQualified());
            FtrainingMapper.insertTeacherFilesTraining(teacherFilesTraining);
        }
        return 1;
    }
}
