package yangtz.cs.liu.campus.service.impl.teacherFiles;

import com.ruoyi.common.core.domain.entity.SchoolTeacher;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.mapper.SysDeptMapper;
import com.ruoyi.system.mapper.SysUserMapper;
import org.apache.catalina.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.controller.A;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClass;
import yangtz.cs.liu.campus.domain.schoolClass.SchoolClassMentor;
import yangtz.cs.liu.campus.domain.schoolgrade.SchoolGrade;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFiles;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNotice;
import yangtz.cs.liu.campus.domain.teacherFiles.TeacherFilesNoticeTotal;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMapper;
import yangtz.cs.liu.campus.mapper.schoolClass.SchoolClassMentorMapper;
import yangtz.cs.liu.campus.mapper.schoolgrade.SchoolGradeMapper;
import yangtz.cs.liu.campus.mapper.teacher.SchoolTeacherMapper;
import yangtz.cs.liu.campus.mapper.teacherFiles.TeacherFilesMapper;
import yangtz.cs.liu.campus.mapper.teacherFiles.TeacherFilesNoticeMapper;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassMentorService;
import yangtz.cs.liu.campus.service.schoolClass.ISchoolClassService;
import yangtz.cs.liu.campus.service.schoolgrade.ISchoolGradeService;
import yangtz.cs.liu.campus.service.teacherFiles.ITeacherFilesNoticeService;
import yangtz.cs.liu.campus.vo.teacherFiles.SchoolClassByGradeVo;
import yangtz.cs.liu.campus.vo.teacherFiles.SchoolGradeByClassVo;
import yangtz.cs.liu.wechat.vo.schoolClass.SchoolClassVo;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 教师档案通知Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-09-06
 */
@Service
public class TeacherFilesNoticeServiceImpl implements ITeacherFilesNoticeService
{
    @Autowired
    private TeacherFilesNoticeMapper teacherFilesNoticeMapper;

    @Autowired
    private TeacherFilesMapper teacherFilesMapper;

    @Autowired
    private SchoolGradeMapper schoolGradeMapper;

    @Autowired
    private SchoolTeacherMapper schoolTeacherMapper;


    @Autowired
    private SysDeptMapper sysDeptMapper;

    @Autowired
    private SysUserMapper sysUserMapper;

    @Autowired
    private SchoolClassMapper schoolClassMapper;
    @Autowired
    private SchoolClassMentorMapper classMentorMapper;
    @Autowired
    private SchoolGradeMapper gradeMapper;
    /**
     * 教师教室档案通知
     * 
     * @param id 教师档案通知主键
     * @return 教师档案通知
     */
    @Override
    public TeacherFilesNotice selectTeacherFilesNoticeById(String id)
    {
        return teacherFilesNoticeMapper.selectTeacherFilesNoticeById(id);
    }

    /**
     * 查询教师档案通知列表
     * 
     * @param teacherFilesNotice 教师档案通知
     * @return 教师档案通知
     */
    @Override
    public List<TeacherFilesNoticeTotal> selectTeacherFilesNoticeList(TeacherFilesNotice teacherFilesNotice)
    {
        return teacherFilesNoticeMapper.selectTeacherFilesNoticeList(teacherFilesNotice);
    }

    /**
     * 新增教师档案通知
     * 
     * @param teacherFilesNotice 教师档案通知
     * @return 结果
     */
    @Override
    public int insertTeacherFilesNotice(TeacherFilesNotice teacherFilesNotice)
    {
        String noticeId = UUID.randomUUID().toString().replaceAll("-","");
        //补充通知字段
        teacherFilesNotice.setNoticeRange("全体教师");
        teacherFilesNotice.setId(noticeId);
        teacherFilesNotice.setNoticeName(teacherFilesNotice.getNoticeYear()+"学年"+teacherFilesNotice.getNoticeSemester()+"教师档案填写");
        teacherFilesNotice.setNoticeState("1");
        teacherFilesNotice.setCreateTime(DateUtils.getNowDate());
        int i = teacherFilesNoticeMapper.insertTeacherFilesNotice(teacherFilesNotice);

        //获取所有带级部的部门
        List<SysDept> sysDepts = sysDeptMapper.selectDepartmentDept("级部");
        List<SysUser>  userList = new ArrayList<>();
        for (SysDept dept :sysDepts){
            String[] split = dept.getAncestors().split(",");
            if (split.length != 2){
                continue;
            }
            //找到每一个级部下所有的人员
            List<SysUser> sysUsers = sysUserMapper.selectDeptAncetorsByPernId(dept.getDeptId().toString());
            Map<String,Object> map = new HashMap<>();
            map.put("gruop",dept.getDeptName());

            sysUsers.forEach(date->{
                date.setParams(map);
            });
            userList.addAll(sysUsers);
        }
        //获取所有老师 去重
        List<SysUser> trrUserList = userList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(()
                -> new TreeSet<>(Comparator.comparing(SysUser :: getUserId))), ArrayList::new));
        List<TeacherFiles>  teacherFilesList = new ArrayList<>();
        for (SysUser user : trrUserList){
            //部门
            Map<String, Object> params = user.getParams();
            String gruopName = (String)params.get("gruop");
            //获取级部
            SchoolGrade schoolGrade = schoolGradeMapper.selectGradeByName(gruopName);
            //查看当前老师是否在班级中当班主任
            //通知所有教师
            List<SchoolClassVo> schoolClassVos = schoolClassMapper.selectTeacherByTeachId(user.getUserId());
           String teahClassName = null;
           String className = null;
            //只取第一个
            if (!schoolClassVos.isEmpty()){
                teahClassName = schoolClassVos.get(0).getClassName();
                className = schoolClassVos.get(0).getClassName();
            }
            //班主任信息
            TeacherFiles teacherFiles = new TeacherFiles();
            teacherFiles.setTeacherId(user.getUserId());
            teacherFiles = teacherFilesAddXx(teacherFiles);
            teacherFiles.setNoticeId(noticeId);
            teacherFiles.setFilesSemester(teacherFilesNotice.getNoticeYear()+"学年"+teacherFilesNotice.getNoticeSemester());
            teacherFiles.setGradeId(schoolGrade.getId());
            teacherFiles.setGradeName(schoolGrade.getGradeName());
            teacherFiles.setBzrClassName(teahClassName);
            teacherFiles.setState("2");
            teacherFiles = teacherFilesAddXx(teacherFiles); //老师个人信息
            //找到老师课程
            // TODO 修改最新学年
            int schoolYear = gradeMapper.isNewSchoolYear();
            List<SchoolClassMentor> mentorByTeacherId = classMentorMapper.getMentorByTeacherId(user.getUserId(), schoolYear);
            if (!mentorByTeacherId.isEmpty()){
                teacherFiles.setCourseName(mentorByTeacherId.get(0).getCourseName());
                if (StringUtils.isEmpty(className)){
                    //根据课程关联找寻班级
                    SchoolClass schoolClass = schoolClassMapper.selectById(mentorByTeacherId.get(0).getClassId());
                    className = schoolClass.getClassName();
                }
            }
            teacherFiles.setClassName(className);
            teacherFilesList.add(teacherFiles);
        }
        //导入数据库
        teacherFilesList.forEach(date->{
            teacherFilesMapper.insertTeacherFiles(date);
        });





//        //获取级部
//        List<SchoolGrade> schoolGrades = schoolGradeMapper.selectNowSchoolGrade();
//        for(SchoolGrade schoolGrade:schoolGrades){
//            Map<Long,TeacherFiles> teacherFilesMap = new HashMap();
//            Long gradeId = schoolGrade.getId();
//            String gradeName = schoolGrade.getGradeName();
//            //获取班级
//            List<SchoolClassByGradeVo> schoolClassByGrade = teacherFilesNoticeMapper.getSchoolClassByGrade(gradeId);
//            for(SchoolClassByGradeVo schoolClass:schoolClassByGrade){
//                Long classId=schoolClass.getId();
//                String classAlias=schoolClass.getClassAlias();
//
//                if(schoolClass.getTeacherId()!=null){
//                    if(teacherFilesMap.get(schoolClass.getTeacherId())==null){
//                        TeacherFiles teacherFiles = new TeacherFiles();
//                        teacherFiles.setTeacherId(schoolClass.getTeacherId());
//                        teacherFiles = teacherFilesAddXx(teacherFiles);
//                        teacherFiles.setNoticeId(noticeId);
//                        teacherFiles.setFilesSemester(teacherFilesNotice.getNoticeYear()+"学年"+teacherFilesNotice.getNoticeSemester());
//                        teacherFiles.setGradeId(gradeId);
//                        teacherFiles.setGradeName(gradeName);
//                        teacherFiles.setBzrClassName(classAlias);
//                        teacherFiles.setState("1");
//                        teacherFilesMap.put(schoolClass.getTeacherId(),teacherFiles);
//                    }else{
//                        TeacherFiles teacherFiles = teacherFilesMap.get(schoolClass.getTeacherId());
//                        String bzrClassName = teacherFiles.getBzrClassName();
//                        if(bzrClassName==null){
//                            teacherFiles.setBzrClassName(classAlias);
//                        }else{
//                            teacherFiles.setBzrClassName(teacherFiles.getBzrClassName()+"、"+classAlias);
//                        }
//                        teacherFilesMap.put(schoolClass.getTeacherId(),teacherFiles);
//                    }
//
//                }
//                //获取班级老师
//                List<SchoolGradeByClassVo> schoolGradeByClassVos = teacherFilesNoticeMapper.selectTeacherByClass(classId);
//                for(SchoolGradeByClassVo grade:schoolGradeByClassVos){
//
//                    if(teacherFilesMap.get(grade.getTeacherId())==null){
//                        //没有记录
//                        TeacherFiles teacherFiles = new TeacherFiles();
//                        teacherFiles.setTeacherId(grade.getTeacherId());
//                        teacherFiles = teacherFilesAddXx(teacherFiles);
//                        teacherFiles.setNoticeId(noticeId);
//                        teacherFiles.setFilesSemester(teacherFilesNotice.getNoticeYear()+"学年"+teacherFilesNotice.getNoticeSemester());
//                        teacherFiles.setGradeId(gradeId);
//                        teacherFiles.setGradeName(gradeName);
//                        teacherFiles.setCourseName(grade.getCourseName());
//                        teacherFiles.setClassName(classAlias);
//                        teacherFiles.setState("1");
//                        teacherFilesMap.put(grade.getTeacherId(),teacherFiles);
//                    }else{
//                        //有记录
//                        TeacherFiles teacherFiles = teacherFilesMap.get(schoolClass.getTeacherId());
//                        if(teacherFiles.getClassName()==null){
//                            teacherFiles.setClassName(classAlias);
//                        }else{
//                            if(!teacherFiles.getClassName().contains(classAlias)){
//                                teacherFiles.setClassName(teacherFiles.getClassName()+"、"+classAlias);
//                            }
//                        }
//                        if(teacherFiles.getCourseName()==null){
//                            teacherFiles.setCourseName(grade.getCourseName());
//                        }else{
//                            if(!teacherFiles.getCourseName().contains(grade.getCourseName())){
//                                teacherFiles.setCourseName(teacherFiles.getCourseName()+"、"+grade.getCourseName());
//                            }
//                        }
//                        teacherFilesMap.put(schoolClass.getTeacherId(),teacherFiles);
//                    }
//                }
//            }
//            teacherFilesMap.forEach((teacherId,teacherFiles)->{
//                teacherFilesMapper.insertTeacherFiles(teacherFiles);
//            });
//        }

        return i;
    }

    TeacherFiles teacherFilesAddXx(TeacherFiles teacherFiles){
        SchoolTeacher schoolTeacher = schoolTeacherMapper.selectSchoolTeacherById(teacherFiles.getTeacherId());
        teacherFiles.setTeacherName(schoolTeacher.getTeacherName());
        teacherFiles.setIdCard(schoolTeacher.getIdCard());
        teacherFiles.setSex(schoolTeacher.getSex());
        teacherFiles.setEducation(schoolTeacher.getEducation());
        Date birthday = schoolTeacher.getBirthday();
        if(birthday!=null){
            SimpleDateFormat dateFormat= new SimpleDateFormat("yyyy");
            Integer birthdayYear = Integer.valueOf(dateFormat.format(birthday));
            Date date = new Date();
            Integer nowYear = Integer.valueOf(dateFormat.format(date));
            teacherFiles.setAge(nowYear-birthdayYear);
        }
        teacherFiles.setTitle("");
        teacherFiles.setAppearance("");
        return teacherFiles;
    }

    /**
     * 修改教师档案通知
     * 
     * @param teacherFilesNotice 教室档案通知
     * @return 结果
     */
    @Override
    public int updateTeacherFilesNotice(TeacherFilesNotice teacherFilesNotice)
    {
        teacherFilesNotice.setUpdateTime(DateUtils.getNowDate());
        teacherFilesNotice.setNoticeName(teacherFilesNotice.getNoticeYear()+"学年"+teacherFilesNotice.getNoticeSemester()+"教师档案填写");
        int i = teacherFilesNoticeMapper.updateTeacherFilesNotice(teacherFilesNotice);
        Map map = new HashMap();
        map.put("noticeId",teacherFilesNotice.getId());
        map.put("filesSemester",teacherFilesNotice.getNoticeYear()+"学年"+teacherFilesNotice.getNoticeSemester());
        teacherFilesMapper.updateTeacherFilesName(map);
        return i;
    }

    @Override
    public int release(String id) {
        //通知
        TeacherFilesNotice teacherFilesNotice =new TeacherFilesNotice();
        teacherFilesNotice.setId(id);
        teacherFilesNotice.setUpdateTime(DateUtils.getNowDate());
        teacherFilesNotice.setNoticeState("2");
        teacherFilesNoticeMapper.updateTeacherFilesNotice(teacherFilesNotice);
        //修改任务状态
        int i = teacherFilesMapper.updateTeacherFilesState(id);
        return i;
    }

    @Override
    public int withdraw(String id) {
        TeacherFilesNotice teacherFilesNotice =new TeacherFilesNotice();
        teacherFilesNotice.setId(id);
        teacherFilesNotice.setUpdateTime(DateUtils.getNowDate());
        teacherFilesNotice.setNoticeState("1");
        int i = teacherFilesMapper.updateTeacherFilesState1(id);
        teacherFilesNoticeMapper.updateTeacherFilesNotice(teacherFilesNotice);
        return i;
    }

    @Override
    public int complete(String id) {
        TeacherFilesNotice teacherFilesNotice =new TeacherFilesNotice();
        teacherFilesNotice.setId(id);
        teacherFilesNotice.setUpdateTime(DateUtils.getNowDate());
        teacherFilesNotice.setNoticeState("7");
        int i = teacherFilesMapper.updateTeacherFilesState7(id);
        teacherFilesNoticeMapper.updateTeacherFilesNotice(teacherFilesNotice);
        return i;
    }

    /**
     * 批量删除教师档案通知
     * 
     * @param ids 需要删除的教室档案通知主键
     * @return 结果
     */
    @Override
    public int deleteTeacherFilesNoticeByIds(String[] ids)
    {
        return teacherFilesNoticeMapper.deleteTeacherFilesNoticeByIds(ids);
    }

    /**
     * 删除教师档案通知信息
     * 
     * @param id 教室档案通知主键
     * @return 结果
     */
    @Override
    public int deleteTeacherFilesNoticeById(String id)
    {
        int i = teacherFilesNoticeMapper.deleteTeacherFilesNoticeById(id);
        teacherFilesMapper.deleteTeacherFilesByNoticeId(id);
        return i;
    }
}
