package yangtz.cs.liu.campus.service.impl.studentChange;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.studentChange.StudentInfoChange;
import yangtz.cs.liu.campus.mapper.studentChange.StudentInfoChangeMapper;
import yangtz.cs.liu.campus.service.studentChange.IStudentInfoChangeService;

/**
 * 学生关键信息变更Service业务层处理
 * 
 * @author wengxiulin
 * @date 2023-02-20
 */
@Service
public class StudentInfoChangeServiceImpl extends ServiceImpl<StudentInfoChangeMapper,StudentInfoChange> implements IStudentInfoChangeService
{
    @Autowired
    private StudentInfoChangeMapper studentInfoChangeMapper;

    /**
     * 查询学生关键信息变更
     * 
     * @param id 学生关键信息变更主键
     * @return 学生关键信息变更
     */
    @Override
    public StudentInfoChange selectStudentInfoChangeById(Long id)
    {
        return studentInfoChangeMapper.selectStudentInfoChangeById(id);
    }

    /**
     * 查询学生关键信息变更列表
     * 
     * @param studentInfoChange 学生关键信息变更
     * @return 学生关键信息变更
     */
    @Override
    public List<StudentInfoChange> selectStudentInfoChangeList(StudentInfoChange studentInfoChange)
    {
        return studentInfoChangeMapper.selectStudentInfoChangeList(studentInfoChange);
    }

    /**
     * 新增学生关键信息变更
     * 
     * @param studentInfoChange 学生关键信息变更
     * @return 结果
     */
    @Override
    public int insertStudentInfoChange(StudentInfoChange studentInfoChange)
    {
        studentInfoChange.setCreateTime(DateUtils.getNowDate());
        return studentInfoChangeMapper.insertStudentInfoChange(studentInfoChange);
    }

    /**
     * 修改学生关键信息变更
     * 
     * @param studentInfoChange 学生关键信息变更
     * @return 结果
     */
    @Override
    public int updateStudentInfoChange(StudentInfoChange studentInfoChange)
    {
        studentInfoChange.setUpdateTime(DateUtils.getNowDate());
        return studentInfoChangeMapper.updateStudentInfoChange(studentInfoChange);
    }

    /**
     * 批量删除学生关键信息变更
     * 
     * @param ids 需要删除的学生关键信息变更主键
     * @return 结果
     */
    @Override
    public int deleteStudentInfoChangeByIds(Long[] ids)
    {
        return studentInfoChangeMapper.deleteStudentInfoChangeByIds(ids);
    }

    /**
     * 删除学生关键信息变更信息
     * 
     * @param id 学生关键信息变更主键
     * @return 结果
     */
    @Override
    public int deleteStudentInfoChangeById(Long id)
    {
        return studentInfoChangeMapper.deleteStudentInfoChangeById(id);
    }
}
