package yangtz.cs.liu.campus.service.impl.student;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.student.SchoolStudentEvaluate;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentEvaluateMapper;
import yangtz.cs.liu.campus.service.student.ISchoolStudentEvaluateService;
import yangtz.cs.liu.wechat.vo.student.SchoolStudentEvaluateVo;

import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;
import static com.ruoyi.common.utils.StringUtils.isNotNull;

@Service
public class SchoolStudentEvaluateServiceImpl extends ServiceImpl<SchoolStudentEvaluateMapper, SchoolStudentEvaluate> implements ISchoolStudentEvaluateService {

    @Autowired
    private SchoolStudentEvaluateMapper schoolStudentEvaluateMapper;

    @Override
    public List<SchoolStudentEvaluate> queryList(SchoolStudentEvaluate schoolStudentEvaluate) {
        LambdaQueryWrapper<SchoolStudentEvaluate> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(schoolStudentEvaluate.getStudentId()), SchoolStudentEvaluate::getStudentId, schoolStudentEvaluate.getStudentId())
                .orderByDesc(SchoolStudentEvaluate::getCreateTime)
        ;
        List<SchoolStudentEvaluate> list = schoolStudentEvaluateMapper.selectList(lqw);
        return list;
    }


    /**
     * 家长获取孩子综合素质测评列表
     */
    @Override
    public List<SchoolStudentEvaluateVo> getEvaluate(Long studentId) {
        return schoolStudentEvaluateMapper.getEvaluate(studentId);
    }

}