package yangtz.cs.liu.campus.service.impl.schoolXxfb;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfb;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbRy;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbTt;
import yangtz.cs.liu.campus.domain.student.SchoolStudent;
import yangtz.cs.liu.campus.mapper.schoolXxfb.SchoolXxfbMapper;
import yangtz.cs.liu.campus.mapper.schoolXxfb.SchoolXxfbRyMapper;
import yangtz.cs.liu.campus.mapper.schoolXxfb.SchoolXxfbTtMapper;
import yangtz.cs.liu.campus.mapper.student.SchoolStudentMapper;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbService;
import yangtz.cs.liu.campus.util.TemplateExcelUtils;
import yangtz.cs.liu.campus.vo.schoolXxfb.AddXxfbVo;
import yangtz.cs.liu.wechat.vo.schoolXxfb.SchoolXxfbVo;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static yangtz.cs.liu.campus.constant.XxfbConstant.SAVE;

@Service
public class SchoolXxfbServiceImpl extends ServiceImpl<SchoolXxfbMapper, SchoolXxfb> implements ISchoolXxfbService {
    @Autowired
    private SchoolXxfbMapper xxfbMapper;
    @Autowired
    private SchoolXxfbRyMapper ryMapper;
    @Autowired
    private SchoolStudentMapper studentMapper;
    @Autowired
    private SchoolXxfbTtMapper ttMapper;

    @Override
    public List<SchoolXxfb> queryList(List<Long> gradeIds, SchoolXxfb schoolXxfb) {
        LambdaQueryWrapper<SchoolXxfb> lqw = new LambdaQueryWrapper<>();
        lqw
                .in(SchoolXxfb::getGradeId, gradeIds)
                .like(isNotNull(schoolXxfb.getXxfbName()), SchoolXxfb::getXxfbName, schoolXxfb.getXxfbName())
                .eq(isNotNull(schoolXxfb.getXxfbZt()), SchoolXxfb::getXxfbZt, schoolXxfb.getXxfbZt())
                .orderByDesc(SchoolXxfb::getCreateTime)
        ;
        List<SchoolXxfb> list = xxfbMapper.selectList(lqw);
        return list;
    }

    @Override
    public void checkImport(MultipartFile file) {

        //获取文件
        Workbook workbook = TemplateExcelUtils.getWorkbook(file);
        //获取表头
        List<String> titles = TemplateExcelUtils.getSheetTitles(workbook);
        if (StringUtils.isNull(titles) || titles.size() == 0) {
            throw new ServiceException("表头为空，请检查");
        }
        if(titles.size() < 2){
            throw new ServiceException("表头数量小于两列，不规范，请检查");
        }
        //如果第一列表头不是身份证号
        if (!("身份证号".equals(titles.get(0)))) {
            throw new ServiceException("第1列表头应为身份证号");
        }
        if (!("姓名".equals(titles.get(1)))) {
            throw new ServiceException("第2列表头应为姓名");
        }
        //判断表头是否有重复
        //去重表头集合   去重之后如果新的表头集合和原表头集合长度一致，则表头没有重复值
        List<String> titlesX = titles.stream().distinct().collect(Collectors.toList());
        if (titlesX.size() != titles.size()){
            throw new ServiceException("列名不能重复，请检查！");
        }

        //获取表内容
        //拿第一个sheet表
        Sheet sheet = workbook.getSheetAt(0);

        // 获取第一行数据（假如第一行就是列名）
        Row sheetTitleRow = sheet.getRow(sheet.getFirstRowNum());
        // 取出最后一列
        short lastCellNum = sheetTitleRow.getLastCellNum();
        // 获取最后一个非空行的行下标，比如总行数为n，则返回的为n-1
        int rows = sheet.getLastRowNum();
        if (0 == rows) {
            throw new ServiceException("Excel内没有数据");
        }
        // 准备记录日志数据
        int failureNum = 0;
        StringBuilder failureMsg = new StringBuilder();
        for (int j = 1; j <= rows; j++) {
            SchoolXxfbRy ry = new SchoolXxfbRy();
            //获得第j行对象
            Row row = sheet.getRow(j);
            //循环遍历第j行第k列的单元格内容
            for (int k = 0; k < lastCellNum; k++) {
                //获取单元格内容
                //Cell cell = row.getCell((short) k);
                Cell cell = row.getCell(k);
                if(k<=1){
                    if (StringUtils.isNull(cell)) {
                        throw new ServiceException("身份证号和姓名所在列，单元格内容不能为空");
                    }
                }else{
                    if (StringUtils.isNull(cell)) {
                        //throw new ServiceException("抱歉，单元格内容不能为空");
                        cell = row.createCell(k);
                        cell.setCellValue(" ");
                    }
                }

                //方式①，，弊端日期类型处理不了
                //DataFormatter formatter = new DataFormatter();
                //单元格不设置数字格式
                //cell.setCellStyle(null);
                //String s = formatter.formatCellValue(cell);

                //方式②,判断单元格是啥内容类型并获取返回的字符串

                String s = "";
                //判断第一二列是否是姓名、身份证号
                if (k <= 1) {
                    try{
                         s = TemplateExcelUtils.getCellValue(cell, workbook);
                    }catch (Exception e){
                        throw new ServiceException("身份证号和姓名所在列，单元格内容不能为空");
                    }
                    if (k == 0) {
                        if ("身份证号".equals(titles.get(0)) || "学生身份证号".equals(titles.get(0))) {
                            //if (StringUtils.isNull(cell.getStringCellValue().toString())) {
                            if (StringUtils.isNull(s) || "".equals(s)) {
                                //throw new ServiceException("第"+ j+1 +"行，第"+k+1+"列" )
                                throw new ServiceException("身份证号所在列内容不能为空，请检查");
                            }
                            ry.setIdCard(s);
                        } else {
                            throw new ServiceException("第1列表头应为身份证号");
                        }
                    } else if (k == 1) {
                        if ("姓名".equals(titles.get(1)) || "学生姓名".equals(titles.get(1))) {
                            //if (StringUtils.isNull(cell.getStringCellValue().toString())) {
                            if (StringUtils.isNull(s) || "".equals(s)) {
                                //throw new ServiceException("第"+ j+1 +"行，第"+k+1+"列" )
                                throw new ServiceException("姓名所在列内容不能为空，请检查");
                            }
                            //ry.setStudentName(cell.getStringCellValue().toString());
                            ry.setStudentName(s);
                        } else {
                            throw new ServiceException("第2列表头应为姓名");
                        }
                    }
                }
            }
            LambdaQueryWrapper<SchoolStudent> lqw = new LambdaQueryWrapper<>();
            lqw
                    .eq(SchoolStudent::getStudentName, ry.getStudentName())
                    .eq(SchoolStudent::getIdCard, ry.getIdCard());
            List<SchoolStudent> studentList = studentMapper.selectList(lqw);
            if (StringUtils.isNull(studentList) || studentList.size() == 0) {
                failureNum++;
                failureMsg.append("<br/>姓名为" + ry.getStudentName() + "、身份证号为"+ry.getIdCard()+"的学生不存在。");
            }
        }

        //此时当前行单元格数据已获取完
        if (failureNum > 0) {
            failureMsg.insert(0, "很抱歉，新增失败！共 " + failureNum + " 条数据格式不正确，错误如下：");
            throw new ServiceException(failureMsg.toString());
        }
    }



   /* @Override
    @Transactional
    public int add(SchoolXxfb schoolXxfb, MultipartFile file) {
        int count = 0;
        //先新增主表
        schoolXxfb.setXxfbZt(SAVE);
        //查询次数为0
        schoolXxfb.setNum(0);
        schoolXxfb.insert();
        if (xxfbMapper.insert(schoolXxfb) > 0) {
            //获取文件
            Workbook workbook = TemplateExcelUtils.getWorkbook(file);
            //获取表头
            List<String> titles = TemplateExcelUtils.getSheetTitles(workbook);
            *//*if (StringUtils.isNull(titles) || titles.size() == 0) {
                throw new ServiceException("表头为空，请检查");
            }*//*
            int i = 1;
            for (String title : titles) {
                SchoolXxfbTt tt = new SchoolXxfbTt();
                //从第三列存储表头（1,2列是身份证号,姓名）
                if (i >= 3) {
                    tt.setXxfbId(schoolXxfb.getId());
                    tt.setTtXh(i);
                    tt.setTtXhname("ry_col" + i);
                    tt.setTtName(title);
                    //存表头信息
                    ttMapper.insert(tt);
                }
                i++;
            }

            //获取表内容
            //拿第一个sheet表
            Sheet sheet = workbook.getSheetAt(0);
            // 定义一个map用于存放excel列的序号和field.
            Map<String, Integer> cellMap = new HashMap<String, Integer>();
            // 获取第一行数据（假如第一行就是列名）
            Row sheetTitleRow = sheet.getRow(sheet.getFirstRowNum());
            // 取出最后一列
            short lastCellNum = sheetTitleRow.getLastCellNum();
            // 获取最后一个非空行的行下标，比如总行数为n，则返回的为n-1
            int rows = sheet.getLastRowNum();
            if (0 == rows) {
                throw new ServiceException("Excel内没有数据");
            }
            for (int j = 1; j <= rows; j++) {
                SchoolXxfbRy ry = new SchoolXxfbRy();
                ry.setXxfbId(schoolXxfb.getId());
                //获得第j行对象
                Row row = sheet.getRow(j);
                //循环遍历第j行第k列的单元格内容
                for (int k = 0; k < lastCellNum; k++) {
                    //获取单元格内容
                    //Cell cell = row.getCell((short) k);
                    Cell cell = row.getCell(k);

                    if (StringUtils.isNull(cell)) {
                        cell = row.createCell(k);
                        cell.setCellValue(" ");
                    }
                    //方式①，，弊端日期类型处理不了
                    //DataFormatter formatter = new DataFormatter();
                    //单元格不设置数字格式
                    //cell.setCellStyle(null);
                    //String s = formatter.formatCellValue(cell);

                    //方式②,判断单元格是啥内容类型并获取返回的字符串
                    String s = TemplateExcelUtils.getCellValue(cell, workbook);

                    //判断第一二列是否是姓名、身份证号
                    if (k <= 1) {
                        if (k == 0) {
                            if ("身份证号".equals(titles.get(0)) || "学生身份证号".equals(titles.get(0))) {
                                if (StringUtils.isNull(cell.getStringCellValue().toString())) {
                                    //throw new ServiceException("第"+ j+1 +"行，第"+k+1+"列" )
                                    throw new ServiceException("身份证号所在列内容不能为空，请检查");
                                }
                                ry.setIdCard(s);
                            } else {
                                throw new ServiceException("第1列表头应为身份证号");
                            }
                        } else if (k == 1) {
                            if ("姓名".equals(titles.get(1)) || "学生姓名".equals(titles.get(1))) {
                                if (StringUtils.isNull(cell.getStringCellValue().toString())) {
                                    //throw new ServiceException("第"+ j+1 +"行，第"+k+1+"列" )
                                    throw new ServiceException("姓名所在列内容不能为空，请检查");
                                }
                                //ry.setStudentName(cell.getStringCellValue().toString());
                                ry.setStudentName(s);
                            } else {
                                throw new ServiceException("第2列表头应为姓名");
                            }
                        }
                    } else {
                        if (StringUtils.isNotNull(s)) {
                            //从第3列开始，K值从2开始
                            switch (k) {
                                case 2:
                                    ry.setRyCol3(s);
                                    break;
                                case 3:
                                    ry.setRyCol4(s);
                                    break;
                                case 4:
                                    ry.setRyCol5(s);
                                    break;
                                case 5:
                                    ry.setRyCol6(s);
                                    break;
                                case 6:
                                    ry.setRyCol7(s);
                                    break;
                                case 7:
                                    ry.setRyCol8(s);
                                    break;
                                case 8:
                                    ry.setRyCol9(s);
                                    break;
                                case 9:
                                    ry.setRyCol10(s);
                                    break;
                                case 10:
                                    ry.setRyCol11(s);
                                    break;
                                case 11:
                                    ry.setRyCol12(s);
                                    break;
                                case 12:
                                    ry.setRyCol13(s);
                                    break;
                                case 13:
                                    ry.setRyCol14(s);
                                    break;
                                case 14:
                                    ry.setRyCol15(s);
                                    break;
                                case 15:
                                    ry.setRyCol16(s);
                                    break;
                                case 16:
                                    ry.setRyCol17(s);
                                    break;
                                case 17:
                                    ry.setRyCol18(s);
                                    break;
                                case 18:
                                    ry.setRyCol19(s);
                                    break;
                                case 19:
                                    ry.setRyCol20(s);
                                    break;
                                case 20:
                                    ry.setRyCol21(s);
                                    break;
                                case 21:
                                    ry.setRyCol22(s);
                                    break;
                                case 22:
                                    ry.setRyCol23(s);
                                    break;
                                case 23:
                                    ry.setRyCol24(s);
                                    break;
                                case 24:
                                    ry.setRyCol25(s);
                                    break;
                                case 25:
                                    ry.setRyCol26(s);
                                    break;
                                case 26:
                                    ry.setRyCol27(s);
                                    break;
                                case 27:
                                    ry.setRyCol28(s);
                                    break;
                                case 28:
                                    ry.setRyCol29(s);
                                    break;
                                case 29:
                                    ry.setRyCol30(s);
                                    break;
                                case 30:
                                    ry.setRyCol31(s);
                                    break;
                                case 31:
                                    ry.setRyCol32(s);
                                    break;
                                case 32:
                                    ry.setRyCol33(s);
                                    break;
                                case 33:
                                    ry.setRyCol34(s);
                                    break;
                                case 34:
                                    ry.setRyCol35(s);
                                    break;
                                case 35:
                                    ry.setRyCol36(s);
                                    break;
                                case 36:
                                    ry.setRyCol37(s);
                                    break;
                                case 37:
                                    ry.setRyCol38(s);
                                    break;
                                case 38:
                                    ry.setRyCol39(s);
                                    break;
                                case 39:
                                    ry.setRyCol40(s);
                                    break;
                                case 40:
                                    ry.setRyCol41(s);
                                    break;
                                case 41:
                                    ry.setRyCol42(s);
                                    break;
                                case 42:
                                    ry.setRyCol43(s);
                                    break;
                                case 43:
                                    ry.setRyCol44(s);
                                    break;
                                case 44:
                                    ry.setRyCol45(s);
                                    break;
                                case 45:
                                    ry.setRyCol46(s);
                                    break;
                                case 46:
                                    ry.setRyCol47(s);
                                    break;
                                case 47:
                                    ry.setRyCol48(s);
                                    break;
                                case 48:
                                    ry.setRyCol49(s);
                                    break;
                                case 49:
                                    ry.setRyCol50(s);
                                    break;
                                case 50:
                                    ry.setRyCol51(s);
                                    break;
                                case 51:
                                    ry.setRyCol52(s);
                                    break;
                                case 52:
                                    ry.setRyCol53(s);
                                    break;
                                case 53:
                                    ry.setRyCol54(s);
                                    break;
                                case 54:
                                    ry.setRyCol55(s);
                                    break;
                                case 55:
                                    ry.setRyCol56(s);
                                    break;
                                case 56:
                                    ry.setRyCol57(s);
                                    break;
                                case 57:
                                    ry.setRyCol58(s);
                                    break;
                                case 58:
                                    ry.setRyCol59(s);
                                    break;
                                case 59:
                                    ry.setRyCol60(s);
                                    break;
                                case 60:
                                    ry.setRyCol61(s);
                                    break;
                                case 61:
                                    ry.setRyCol62(s);
                                    break;
                                case 62:
                                    ry.setRyCol63(s);
                                    break;
                                case 63:
                                    ry.setRyCol64(s);
                                    break;
                                case 64:
                                    ry.setRyCol65(s);
                                    break;
                                case 65:
                                    ry.setRyCol66(s);
                                    break;
                                case 66:
                                    ry.setRyCol67(s);
                                    break;
                                case 67:
                                    ry.setRyCol68(s);
                                    break;
                                case 68:
                                    ry.setRyCol69(s);
                                    break;
                                case 69:
                                    ry.setRyCol70(s);
                                    break;
                                case 70:
                                    ry.setRyCol71(s);
                                    break;
                                case 71:
                                    ry.setRyCol72(s);
                                    break;
                                case 72:
                                    ry.setRyCol73(s);
                                    break;
                                case 73:
                                    ry.setRyCol74(s);
                                    break;
                                case 74:
                                    ry.setRyCol75(s);
                                    break;
                                default:
                                    break;
                            }
                        }

                    }
                }
                LambdaQueryWrapper<SchoolStudent> lqw = new LambdaQueryWrapper<>();
                lqw
                        .eq(SchoolStudent::getStudentName, ry.getStudentName())
                        .eq(SchoolStudent::getIdCard, ry.getIdCard());
                List<SchoolStudent> studentList = studentMapper.selectList(lqw);
                if (StringUtils.isNotNull(studentList) && studentList.size() > 0) {
                    SchoolStudent student = studentList.get(0);
                    ry.setStudentId(student.getId());
                }
                //此时当前行单元格数据已获取完
                count += ryMapper.insert(ry);
            }
        }
        return count;
    }*/
   @Override
   @Transactional(rollbackFor = Exception.class)
   public int add(AddXxfbVo vo) {
       int count = 0;
       //先新增主表
       SchoolXxfb schoolXxfb = new SchoolXxfb();
       schoolXxfb.setXxfbName(vo.getXxfbName());
       schoolXxfb.setGradeId(vo.getGradeId());
       schoolXxfb.setXxfbZt(SAVE);
       //查询次数为0
       schoolXxfb.setNum(0);
       schoolXxfb.insert();
       if (xxfbMapper.insert(schoolXxfb) > 0) {
           //获取文件
           Workbook workbook = TemplateExcelUtils.getWorkbook(vo.getFile());
           //获取表头
           List<String> titles = TemplateExcelUtils.getSheetTitles(workbook);
            /*if (StringUtils.isNull(titles) || titles.size() == 0) {
                throw new ServiceException("表头为空，请检查");
            }*/
           int i = 1;
           for (String title : titles) {
               SchoolXxfbTt tt = new SchoolXxfbTt();
               //从第三列存储表头（1,2列是身份证号,姓名）
               if (i >= 3) {
                   tt.setXxfbId(schoolXxfb.getId());
                   tt.setTtXh(i);
                   tt.setTtXhname("ry_col" + i);
                   tt.setTtName(title);
                   //存表头信息
                   ttMapper.insert(tt);
               }
               i++;
           }

           //获取表内容
           //拿第一个sheet表
           Sheet sheet = workbook.getSheetAt(0);
           // 定义一个map用于存放excel列的序号和field.
           Map<String, Integer> cellMap = new HashMap<String, Integer>();
           // 获取第一行数据（假如第一行就是列名）
           Row sheetTitleRow = sheet.getRow(sheet.getFirstRowNum());
           // 取出最后一列
           short lastCellNum = sheetTitleRow.getLastCellNum();
           // 获取最后一个非空行的行下标，比如总行数为n，则返回的为n-1
           int rows = sheet.getLastRowNum();
           if (0 == rows) {
               throw new ServiceException("Excel内没有数据");
           }
           for (int j = 1; j <= rows; j++) {
               SchoolXxfbRy ry = new SchoolXxfbRy();
               ry.setXxfbId(schoolXxfb.getId());
               //获得第j行对象
               Row row = sheet.getRow(j);
               //循环遍历第j行第k列的单元格内容
               for (int k = 0; k < lastCellNum; k++) {
                   //获取单元格内容
                   //Cell cell = row.getCell((short) k);
                   Cell cell = row.getCell(k);

                   if (StringUtils.isNull(cell)) {
                       cell = row.createCell(k);
                       cell.setCellValue(" ");
                   }
                   //方式①，，弊端日期类型处理不了
                   //DataFormatter formatter = new DataFormatter();
                   //单元格不设置数字格式
                   //cell.setCellStyle(null);
                   //String s = formatter.formatCellValue(cell);

                   //方式②,判断单元格是啥内容类型并获取返回的字符串
                   String s = TemplateExcelUtils.getCellValue(cell, workbook);

                   //判断第一二列是否是姓名、身份证号
                   if (k <= 1) {
                       if (k == 0) {
                           if ("身份证号".equals(titles.get(0)) || "学生身份证号".equals(titles.get(0))) {
                               if (StringUtils.isNull(s) || "".equals(s)) {
                                   //throw new ServiceException("第"+ j+1 +"行，第"+k+1+"列" )
                                   throw new ServiceException("身份证号所在列内容不能为空，请检查");
                               }
                               ry.setIdCard(s);
                           } else {
                               throw new ServiceException("第1列表头应为身份证号");
                           }
                       } else if (k == 1) {
                           if ("姓名".equals(titles.get(1)) || "学生姓名".equals(titles.get(1))) {
                               if (StringUtils.isNull(s) || "".equals(s)) {
                                   //throw new ServiceException("第"+ j+1 +"行，第"+k+1+"列" )
                                   throw new ServiceException("姓名所在列内容不能为空，请检查");
                               }
                               //ry.setStudentName(cell.getStringCellValue().toString());
                               ry.setStudentName(s);
                           } else {
                               throw new ServiceException("第2列表头应为姓名");
                           }
                       }
                   } else {
                       if (StringUtils.isNotNull(s)) {
                           //从第3列开始，K值从2开始
                           switch (k) {
                               case 2:
                                   ry.setRyCol3(s);
                                   break;
                               case 3:
                                   ry.setRyCol4(s);
                                   break;
                               case 4:
                                   ry.setRyCol5(s);
                                   break;
                               case 5:
                                   ry.setRyCol6(s);
                                   break;
                               case 6:
                                   ry.setRyCol7(s);
                                   break;
                               case 7:
                                   ry.setRyCol8(s);
                                   break;
                               case 8:
                                   ry.setRyCol9(s);
                                   break;
                               case 9:
                                   ry.setRyCol10(s);
                                   break;
                               case 10:
                                   ry.setRyCol11(s);
                                   break;
                               case 11:
                                   ry.setRyCol12(s);
                                   break;
                               case 12:
                                   ry.setRyCol13(s);
                                   break;
                               case 13:
                                   ry.setRyCol14(s);
                                   break;
                               case 14:
                                   ry.setRyCol15(s);
                                   break;
                               case 15:
                                   ry.setRyCol16(s);
                                   break;
                               case 16:
                                   ry.setRyCol17(s);
                                   break;
                               case 17:
                                   ry.setRyCol18(s);
                                   break;
                               case 18:
                                   ry.setRyCol19(s);
                                   break;
                               case 19:
                                   ry.setRyCol20(s);
                                   break;
                               case 20:
                                   ry.setRyCol21(s);
                                   break;
                               case 21:
                                   ry.setRyCol22(s);
                                   break;
                               case 22:
                                   ry.setRyCol23(s);
                                   break;
                               case 23:
                                   ry.setRyCol24(s);
                                   break;
                               case 24:
                                   ry.setRyCol25(s);
                                   break;
                               case 25:
                                   ry.setRyCol26(s);
                                   break;
                               case 26:
                                   ry.setRyCol27(s);
                                   break;
                               case 27:
                                   ry.setRyCol28(s);
                                   break;
                               case 28:
                                   ry.setRyCol29(s);
                                   break;
                               case 29:
                                   ry.setRyCol30(s);
                                   break;
                               case 30:
                                   ry.setRyCol31(s);
                                   break;
                               case 31:
                                   ry.setRyCol32(s);
                                   break;
                               case 32:
                                   ry.setRyCol33(s);
                                   break;
                               case 33:
                                   ry.setRyCol34(s);
                                   break;
                               case 34:
                                   ry.setRyCol35(s);
                                   break;
                               case 35:
                                   ry.setRyCol36(s);
                                   break;
                               case 36:
                                   ry.setRyCol37(s);
                                   break;
                               case 37:
                                   ry.setRyCol38(s);
                                   break;
                               case 38:
                                   ry.setRyCol39(s);
                                   break;
                               case 39:
                                   ry.setRyCol40(s);
                                   break;
                               case 40:
                                   ry.setRyCol41(s);
                                   break;
                               case 41:
                                   ry.setRyCol42(s);
                                   break;
                               case 42:
                                   ry.setRyCol43(s);
                                   break;
                               case 43:
                                   ry.setRyCol44(s);
                                   break;
                               case 44:
                                   ry.setRyCol45(s);
                                   break;
                               case 45:
                                   ry.setRyCol46(s);
                                   break;
                               case 46:
                                   ry.setRyCol47(s);
                                   break;
                               case 47:
                                   ry.setRyCol48(s);
                                   break;
                               case 48:
                                   ry.setRyCol49(s);
                                   break;
                               case 49:
                                   ry.setRyCol50(s);
                                   break;
                               case 50:
                                   ry.setRyCol51(s);
                                   break;
                               case 51:
                                   ry.setRyCol52(s);
                                   break;
                               case 52:
                                   ry.setRyCol53(s);
                                   break;
                               case 53:
                                   ry.setRyCol54(s);
                                   break;
                               case 54:
                                   ry.setRyCol55(s);
                                   break;
                               case 55:
                                   ry.setRyCol56(s);
                                   break;
                               case 56:
                                   ry.setRyCol57(s);
                                   break;
                               case 57:
                                   ry.setRyCol58(s);
                                   break;
                               case 58:
                                   ry.setRyCol59(s);
                                   break;
                               case 59:
                                   ry.setRyCol60(s);
                                   break;
                               case 60:
                                   ry.setRyCol61(s);
                                   break;
                               case 61:
                                   ry.setRyCol62(s);
                                   break;
                               case 62:
                                   ry.setRyCol63(s);
                                   break;
                               case 63:
                                   ry.setRyCol64(s);
                                   break;
                               case 64:
                                   ry.setRyCol65(s);
                                   break;
                               case 65:
                                   ry.setRyCol66(s);
                                   break;
                               case 66:
                                   ry.setRyCol67(s);
                                   break;
                               case 67:
                                   ry.setRyCol68(s);
                                   break;
                               case 68:
                                   ry.setRyCol69(s);
                                   break;
                               case 69:
                                   ry.setRyCol70(s);
                                   break;
                               case 70:
                                   ry.setRyCol71(s);
                                   break;
                               case 71:
                                   ry.setRyCol72(s);
                                   break;
                               case 72:
                                   ry.setRyCol73(s);
                                   break;
                               case 73:
                                   ry.setRyCol74(s);
                                   break;
                               case 74:
                                   ry.setRyCol75(s);
                                   break;
                               default:
                                   break;
                           }
                       }

                   }
               }
               LambdaQueryWrapper<SchoolStudent> lqw = new LambdaQueryWrapper<>();
               lqw
                       .eq(SchoolStudent::getStudentName, ry.getStudentName())
                       .eq(SchoolStudent::getIdCard, ry.getIdCard());
               List<SchoolStudent> studentList = studentMapper.selectList(lqw);
               if (StringUtils.isNotNull(studentList) && studentList.size() > 0) {
                   SchoolStudent student = studentList.get(0);
                   ry.setStudentId(student.getId());
               }
               //此时当前行单元格数据已获取完
               count += ryMapper.insert(ry);
           }
       }
       return count;
   }


    /**
     * wx家长获取学生所得到的信息发布
     *
     * @return
     */
    @Override
    public List<SchoolXxfbVo> getList(Long studentId) {
        LambdaQueryWrapper<SchoolXxfbRy> ryLqw = new LambdaQueryWrapper<>();
        ryLqw
                .select(SchoolXxfbRy::getXxfbId, SchoolXxfbRy::getRyFk)
                .eq(isNotNull(studentId), SchoolXxfbRy::getStudentId, studentId);
        List<SchoolXxfbRy> ryList = ryMapper.selectList(ryLqw);
        List<SchoolXxfbVo> voList = new ArrayList<>();
        for (SchoolXxfbRy ry : ryList) {
            SchoolXxfbVo schoolXxfbVo = new SchoolXxfbVo();
            schoolXxfbVo.setFk(ry.getRyFk());
            SchoolXxfb schoolXxfb = xxfbMapper.selectById(ry.getXxfbId());
            BeanUtils.copyProperties(schoolXxfb, schoolXxfbVo);
            voList.add(schoolXxfbVo);
        }
        return voList;
    }
}
