package yangtz.cs.liu.campus.service.impl.schoolXxfb;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import yangtz.cs.liu.campus.domain.schoolXxfb.SchoolXxfbRy;
import yangtz.cs.liu.campus.mapper.schoolXxfb.SchoolXxfbRyMapper;
import yangtz.cs.liu.campus.service.schoolXxfb.ISchoolXxfbRyService;
import yangtz.cs.liu.campus.vo.schoolXxfb.DataLookVo;
import yangtz.cs.liu.campus.vo.schoolXxfb.XxfbDataVo;
import yangtz.cs.liu.campus.vo.schoolXxfb.XxfbTitleVo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotNull;
import static yangtz.cs.liu.campus.constant.XxfbConstant.MATCH;
import static yangtz.cs.liu.campus.constant.XxfbConstant.NOMATCH;

@Service
public class SchoolXxfbRyServiceImpl extends ServiceImpl<SchoolXxfbRyMapper, SchoolXxfbRy> implements ISchoolXxfbRyService {

    @Autowired
    private SchoolXxfbRyMapper ryMapper;

    //数据
    @Override
    public List<XxfbDataVo> getListByXxfbId(XxfbDataVo vo) {
        List<XxfbDataVo> list = ryMapper.getListByXxfbId(vo);
        //给匹配结果赋值，有student_id是已匹配1，没有就是未匹配0
        for(XxfbDataVo dataVo : list){
            if(StringUtils.isNull(dataVo.getStudentId())){
                dataVo.setMatchResult(NOMATCH);
            }else {
                dataVo.setMatchResult(MATCH);
            }
        }
        return list;
    }

    //数据查看
    @Override
    public List<DataLookVo> getDataLookList(DataLookVo vo) {
        List<DataLookVo> list = ryMapper.getDataLookList(vo);
        //处理是否查看，是否反馈
        for(DataLookVo lookVo : list){
            //是否查看
            if(StringUtils.isNotNull(lookVo.getRyCksj())){
                lookVo.setIsView(MATCH);
            }else {
                lookVo.setIsView(NOMATCH);
            }

            //是否反馈
            if(StringUtils.isNotNull(lookVo.getRyTjsj())){
                lookVo.setFeedback(MATCH);
            }else {
                lookVo.setFeedback(NOMATCH);
            }
        }
        return list;
    }

    @Override
    public Map<String, String> handle(XxfbTitleVo titleVo, Long xxfbId, Long studentId) {
        LambdaQueryWrapper<SchoolXxfbRy> lqw = new LambdaQueryWrapper<>();
        lqw
                .eq(isNotNull(xxfbId), SchoolXxfbRy::getXxfbId, xxfbId)
                .eq(isNotNull(studentId), SchoolXxfbRy::getStudentId, studentId);
        SchoolXxfbRy schoolXxfbRy = ryMapper.selectOne(lqw);
        HashMap<String, String> map = new HashMap<>();
        if (isNotNull(titleVo.getRyCol3())) {
            map.put(titleVo.getRyCol3(), schoolXxfbRy.getRyCol3());
        }
        if (isNotNull(titleVo.getRyCol4())) {
            map.put(titleVo.getRyCol4(), schoolXxfbRy.getRyCol4());
        }
        if (isNotNull(titleVo.getRyCol5())) {
            map.put(titleVo.getRyCol5(), schoolXxfbRy.getRyCol5());
        }
        if (isNotNull(titleVo.getRyCol6())) {
            map.put(titleVo.getRyCol6(), schoolXxfbRy.getRyCol6());
        }
        if (isNotNull(titleVo.getRyCol7())) {
            map.put(titleVo.getRyCol7(), schoolXxfbRy.getRyCol7());
        }
        if (isNotNull(titleVo.getRyCol8())) {
            map.put(titleVo.getRyCol8(), schoolXxfbRy.getRyCol8());
        }
        if (isNotNull(titleVo.getRyCol9())) {
            map.put(titleVo.getRyCol9(), schoolXxfbRy.getRyCol9());
        }
        if (isNotNull(titleVo.getRyCol10())) {
            map.put(titleVo.getRyCol10(), schoolXxfbRy.getRyCol10());
        }
        if (isNotNull(titleVo.getRyCol11())) {
            map.put(titleVo.getRyCol11(), schoolXxfbRy.getRyCol11());
        }
        if (isNotNull(titleVo.getRyCol12())) {
            map.put(titleVo.getRyCol12(), schoolXxfbRy.getRyCol12());
        }
        if (isNotNull(titleVo.getRyCol13())) {
            map.put(titleVo.getRyCol13(), schoolXxfbRy.getRyCol13());
        }
        if (isNotNull(titleVo.getRyCol14())) {
            map.put(titleVo.getRyCol14(), schoolXxfbRy.getRyCol14());
        }
        if (isNotNull(titleVo.getRyCol15())) {
            map.put(titleVo.getRyCol15(), schoolXxfbRy.getRyCol15());
        }
        if (isNotNull(titleVo.getRyCol16())) {
            map.put(titleVo.getRyCol16(), schoolXxfbRy.getRyCol16());
        }
        if (isNotNull(titleVo.getRyCol17())) {
            map.put(titleVo.getRyCol17(), schoolXxfbRy.getRyCol17());
        }
        if (isNotNull(titleVo.getRyCol18())) {
            map.put(titleVo.getRyCol18(), schoolXxfbRy.getRyCol18());
        }
        if (isNotNull(titleVo.getRyCol19())) {
            map.put(titleVo.getRyCol19(), schoolXxfbRy.getRyCol19());
        }
        if (isNotNull(titleVo.getRyCol20())) {
            map.put(titleVo.getRyCol20(), schoolXxfbRy.getRyCol20());
        }
        if (isNotNull(titleVo.getRyCol21())) {
            map.put(titleVo.getRyCol21(), schoolXxfbRy.getRyCol21());
        }
        if (isNotNull(titleVo.getRyCol22())) {
            map.put(titleVo.getRyCol22(), schoolXxfbRy.getRyCol22());
        }
        if (isNotNull(titleVo.getRyCol23())) {
            map.put(titleVo.getRyCol23(), schoolXxfbRy.getRyCol23());
        }
        if (isNotNull(titleVo.getRyCol24())) {
            map.put(titleVo.getRyCol24(), schoolXxfbRy.getRyCol24());
        }
        if (isNotNull(titleVo.getRyCol25())) {
            map.put(titleVo.getRyCol25(), schoolXxfbRy.getRyCol25());
        }
        if (isNotNull(titleVo.getRyCol26())) {
            map.put(titleVo.getRyCol26(), schoolXxfbRy.getRyCol26());
        }
        if (isNotNull(titleVo.getRyCol27())) {
            map.put(titleVo.getRyCol27(), schoolXxfbRy.getRyCol27());
        }
        if (isNotNull(titleVo.getRyCol28())) {
            map.put(titleVo.getRyCol28(), schoolXxfbRy.getRyCol28());
        }
        if (isNotNull(titleVo.getRyCol29())) {
            map.put(titleVo.getRyCol29(), schoolXxfbRy.getRyCol29());
        }
        if (isNotNull(titleVo.getRyCol30())) {
            map.put(titleVo.getRyCol30(), schoolXxfbRy.getRyCol30());
        }
        if (isNotNull(titleVo.getRyCol31())) {
            map.put(titleVo.getRyCol31(), schoolXxfbRy.getRyCol31());
        }
        if (isNotNull(titleVo.getRyCol32())) {
            map.put(titleVo.getRyCol32(), schoolXxfbRy.getRyCol32());
        }
        if (isNotNull(titleVo.getRyCol33())) {
            map.put(titleVo.getRyCol33(), schoolXxfbRy.getRyCol33());
        }
        if (isNotNull(titleVo.getRyCol34())) {
            map.put(titleVo.getRyCol34(), schoolXxfbRy.getRyCol34());
        }
        if (isNotNull(titleVo.getRyCol35())) {
            map.put(titleVo.getRyCol35(), schoolXxfbRy.getRyCol35());
        }
        if (isNotNull(titleVo.getRyCol36())) {
            map.put(titleVo.getRyCol36(), schoolXxfbRy.getRyCol36());
        }
        if (isNotNull(titleVo.getRyCol37())) {
            map.put(titleVo.getRyCol37(), schoolXxfbRy.getRyCol37());
        }
        if (isNotNull(titleVo.getRyCol38())) {
            map.put(titleVo.getRyCol38(), schoolXxfbRy.getRyCol38());
        }
        if (isNotNull(titleVo.getRyCol39())) {
            map.put(titleVo.getRyCol39(), schoolXxfbRy.getRyCol39());
        }
        if (isNotNull(titleVo.getRyCol40())) {
            map.put(titleVo.getRyCol40(), schoolXxfbRy.getRyCol40());
        }
        if (isNotNull(titleVo.getRyCol41())) {
            map.put(titleVo.getRyCol41(), schoolXxfbRy.getRyCol41());
        }
        if (isNotNull(titleVo.getRyCol42())) {
            map.put(titleVo.getRyCol42(), schoolXxfbRy.getRyCol42());
        }
        if (isNotNull(titleVo.getRyCol43())) {
            map.put(titleVo.getRyCol43(), schoolXxfbRy.getRyCol43());
        }
        if (isNotNull(titleVo.getRyCol44())) {
            map.put(titleVo.getRyCol44(), schoolXxfbRy.getRyCol44());
        }
        if (isNotNull(titleVo.getRyCol45())) {
            map.put(titleVo.getRyCol45(), schoolXxfbRy.getRyCol45());
        }
        if (isNotNull(titleVo.getRyCol46())) {
            map.put(titleVo.getRyCol46(), schoolXxfbRy.getRyCol46());
        }
        if (isNotNull(titleVo.getRyCol47())) {
            map.put(titleVo.getRyCol47(), schoolXxfbRy.getRyCol47());
        }
        if (isNotNull(titleVo.getRyCol48())) {
            map.put(titleVo.getRyCol48(), schoolXxfbRy.getRyCol48());
        }
        if (isNotNull(titleVo.getRyCol49())) {
            map.put(titleVo.getRyCol49(), schoolXxfbRy.getRyCol49());
        }
        if (isNotNull(titleVo.getRyCol50())) {
            map.put(titleVo.getRyCol50(), schoolXxfbRy.getRyCol50());
        }
        if (isNotNull(titleVo.getRyCol51())) {
            map.put(titleVo.getRyCol51(), schoolXxfbRy.getRyCol51());
        }
        if (isNotNull(titleVo.getRyCol52())) {
            map.put(titleVo.getRyCol52(), schoolXxfbRy.getRyCol52());
        }
        if (isNotNull(titleVo.getRyCol53())) {
            map.put(titleVo.getRyCol53(), schoolXxfbRy.getRyCol53());
        }
        if (isNotNull(titleVo.getRyCol54())) {
            map.put(titleVo.getRyCol54(), schoolXxfbRy.getRyCol54());
        }
        if (isNotNull(titleVo.getRyCol55())) {
            map.put(titleVo.getRyCol55(), schoolXxfbRy.getRyCol55());
        }
        if (isNotNull(titleVo.getRyCol56())) {
            map.put(titleVo.getRyCol56(), schoolXxfbRy.getRyCol56());
        }
        if (isNotNull(titleVo.getRyCol57())) {
            map.put(titleVo.getRyCol57(), schoolXxfbRy.getRyCol57());
        }
        if (isNotNull(titleVo.getRyCol58())) {
            map.put(titleVo.getRyCol58(), schoolXxfbRy.getRyCol58());
        }
        if (isNotNull(titleVo.getRyCol59())) {
            map.put(titleVo.getRyCol59(), schoolXxfbRy.getRyCol59());
        }
        if (isNotNull(titleVo.getRyCol60())) {
            map.put(titleVo.getRyCol60(), schoolXxfbRy.getRyCol60());
        }
        if (isNotNull(titleVo.getRyCol61())) {
            map.put(titleVo.getRyCol61(), schoolXxfbRy.getRyCol61());
        }
        if (isNotNull(titleVo.getRyCol62())) {
            map.put(titleVo.getRyCol62(), schoolXxfbRy.getRyCol62());
        }
        if (isNotNull(titleVo.getRyCol63())) {
            map.put(titleVo.getRyCol63(), schoolXxfbRy.getRyCol63());
        }
        if (isNotNull(titleVo.getRyCol64())) {
            map.put(titleVo.getRyCol64(), schoolXxfbRy.getRyCol64());
        }
        if (isNotNull(titleVo.getRyCol65())) {
            map.put(titleVo.getRyCol65(), schoolXxfbRy.getRyCol65());
        }
        if (isNotNull(titleVo.getRyCol66())) {
            map.put(titleVo.getRyCol66(), schoolXxfbRy.getRyCol66());
        }
        if (isNotNull(titleVo.getRyCol67())) {
            map.put(titleVo.getRyCol67(), schoolXxfbRy.getRyCol67());
        }
        if (isNotNull(titleVo.getRyCol68())) {
            map.put(titleVo.getRyCol68(), schoolXxfbRy.getRyCol68());
        }
        if (isNotNull(titleVo.getRyCol69())) {
            map.put(titleVo.getRyCol69(), schoolXxfbRy.getRyCol69());
        }
        if (isNotNull(titleVo.getRyCol70())) {
            map.put(titleVo.getRyCol70(), schoolXxfbRy.getRyCol70());
        }
        if (isNotNull(titleVo.getRyCol71())) {
            map.put(titleVo.getRyCol71(), schoolXxfbRy.getRyCol71());
        }
        if (isNotNull(titleVo.getRyCol72())) {
            map.put(titleVo.getRyCol72(), schoolXxfbRy.getRyCol72());
        }
        if (isNotNull(titleVo.getRyCol73())) {
            map.put(titleVo.getRyCol73(), schoolXxfbRy.getRyCol73());
        }
        if (isNotNull(titleVo.getRyCol74())) {
            map.put(titleVo.getRyCol74(), schoolXxfbRy.getRyCol74());
        }
        if (isNotNull(titleVo.getRyCol75())) {
            map.put(titleVo.getRyCol75(), schoolXxfbRy.getRyCol75());
        }
        return map;
    }
}
